/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Hyperrectangles.RISE;

import keel.Dataset.Attribute;

public class Rule {
    private static int size;
    private static boolean[] isNominal;
    private double[] valueMin = new double[size];
    private double[] valueMax = new double[size];
    private double[] valueNom = new double[size];
    private boolean[] dontCare = new boolean[size];
    private int output;
    private double laplaceAcc;
    private static int S;
    private static int[][][] ACV;
    private static int[][] AC;
    private static int nClasses;
    private static int[] nValues;
    private static int maxValue;
    private static int Q;

    public static void setSize(int value) {
        size = value;
    }

    public static void setQ(int value) {
        Q = value;
    }

    public static void setS(int value) {
        S = value;
    }

    public static void setAttributes(Attribute[] inputs) {
        isNominal = new boolean[size];
        for (int i = 0; i < size; ++i) {
            Rule.isNominal[i] = inputs[i].getType() == 0;
        }
    }

    public static void setNClasses(int value) {
        nClasses = value;
        nValues = new int[size];
        maxValue = -1;
    }

    public static void setNumValue(int value, int pos) {
        Rule.nValues[pos] = value;
        if (maxValue < value) {
            maxValue = value;
        }
    }

    public void setLaplaceAcc(double acc) {
        this.laplaceAcc = acc;
    }

    public int getOutput() {
        return this.output;
    }

    public double getLaplaceAcc() {
        return this.laplaceAcc;
    }

    public static void loadSVDMmatrix(double[][] instances, int[] outputs) {
        int j;
        int i;
        ACV = new int[size][nClasses][maxValue];
        AC = new int[size][nClasses];
        for (i = 0; i < size; ++i) {
            for (j = 0; j < nClasses; ++j) {
                for (int k = 0; k < maxValue; ++k) {
                    Rule.ACV[i][j][k] = 0;
                }
                Rule.AC[i][j] = 0;
            }
        }
        for (i = 0; i < instances.length; ++i) {
            for (j = 0; j < instances[i].length; ++j) {
                if (!isNominal[j]) continue;
                int intValue = (int)(instances[i][j] * (double)(nValues[j] - 1));
                int[] nArray = ACV[j][outputs[i]];
                int n = intValue;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = AC[j];
                int n2 = outputs[i];
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
    }

    public Rule() {
        this.output = -1;
        this.laplaceAcc = -1.0;
    }

    public Rule(double[] instance, int out) {
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                this.valueNom[i] = instance[i];
            } else {
                this.valueMax[i] = instance[i];
                this.valueMin[i] = instance[i];
            }
            this.dontCare[i] = false;
        }
        this.output = out;
    }

    public void loadRule(double[] instance, int out) {
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                this.valueNom[i] = instance[i];
            } else {
                this.valueMax[i] = instance[i];
                this.valueMin[i] = instance[i];
            }
            this.dontCare[i] = false;
        }
        this.output = out;
    }

    public boolean inside(double[] instance) {
        boolean isInside = true;
        for (int i = 0; i < size && isInside; ++i) {
            if (isNominal[i]) {
                if (this.dontCare[i] || instance[i] == this.valueNom[i]) continue;
                isInside = false;
                continue;
            }
            if (instance[i] < this.valueMin[i]) {
                isInside = false;
            }
            if (!(instance[i] > this.valueMax[i])) continue;
            isInside = false;
        }
        return isInside;
    }

    public void mostSpecificGeneralization(double[] instance) {
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                if (this.dontCare[i] || instance[i] == this.valueNom[i]) continue;
                this.dontCare[i] = true;
                continue;
            }
            if (instance[i] < this.valueMin[i]) {
                this.valueMin[i] = instance[i];
            }
            if (!(instance[i] > this.valueMax[i])) continue;
            this.valueMax[i] = instance[i];
        }
    }

    public Rule clone() {
        Rule clon = new Rule();
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                clon.valueNom[i] = this.valueNom[i];
            } else {
                clon.valueMax[i] = this.valueMax[i];
                clon.valueMin[i] = this.valueMin[i];
            }
            clon.dontCare[i] = this.dontCare[i];
        }
        clon.output = this.output;
        clon.laplaceAcc = this.laplaceAcc;
        return clon;
    }

    public boolean equals(Object rul) {
        Rule another = (Rule)rul;
        boolean isEqual = true;
        if (this.output != another.output) {
            isEqual = false;
        }
        for (int i = 0; i < size && isEqual; ++i) {
            if (isNominal[i]) {
                if (this.dontCare[i] != another.dontCare[i]) {
                    isEqual = false;
                    continue;
                }
                if (this.dontCare[i] || this.valueNom[i] == another.valueNom[i]) continue;
                isEqual = false;
                continue;
            }
            if (this.valueMin[i] != another.valueMin[i]) {
                isEqual = false;
            }
            if (this.valueMax[i] == another.valueMax[i]) continue;
            isEqual = false;
        }
        return isEqual;
    }

    public String toString() {
        String text = "";
        for (int i = 0; i < size; ++i) {
            text = text + "Att" + i + ": ";
            if (isNominal[i]) {
                if (this.dontCare[i]) {
                    text = text + "TRUE ";
                    continue;
                }
                text = text + this.valueNom + " ";
                continue;
            }
            text = text + this.valueMin[i] + "-";
            text = text + this.valueMax[i] + " ";
        }
        text = text + "Class = " + this.output;
        text = text + " Acc= " + this.laplaceAcc;
        return text;
    }

    public double distance(double[] instance) {
        double dist = 0.0;
        for (int i = 0; i < size; ++i) {
            double inc;
            if (this.dontCare[i]) continue;
            if (isNominal[i]) {
                inc = this.SVDM(this.valueNom[i], instance[i], i);
                dist += Math.pow(inc, S);
                continue;
            }
            if (instance[i] < this.valueMin[i]) {
                inc = this.valueMin[i] - instance[i];
                dist += Math.pow(inc, S);
            }
            if (!(instance[i] > this.valueMax[i])) continue;
            inc = instance[i] - this.valueMax[i];
            dist += Math.pow(inc, S);
        }
        return dist;
    }

    private double SVDM(double value1, double value2, int att) {
        double dist = 0.0;
        int denom1 = (int)(value1 * (double)(nValues[att] - 1));
        int denom2 = (int)(value2 * (double)(nValues[att] - 1));
        for (int i = 0; i < nClasses; ++i) {
            int count1 = ACV[att][i][denom1];
            int count2 = ACV[att][i][denom2];
            if (count1 == count2) continue;
            int min = 0;
            int max = 0;
            if (count1 > count2) {
                max = count1;
                min = count2;
            }
            if (count2 > count1) {
                max = count2;
                min = count1;
            }
            double aux = (double)(max - min) / (double)AC[att][i];
            dist += Math.pow(aux, Q);
        }
        return dist;
    }
}

