/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.LVQ;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public abstract class LVQGenerator
extends PrototypeGenerator {
    protected int iterations = 10;
    protected int numberOfPrototypesGenerated = 10;
    protected boolean initialset = false;
    protected PrototypeSet initial;

    public LVQGenerator(PrototypeSet _trainingDataSet, int iterations, int n) {
        super(_trainingDataSet);
        this.algorithmName = "LVQ";
        this.iterations = iterations;
        this.numberOfPrototypesGenerated = n;
    }

    public LVQGenerator(PrototypeSet InitialSet, PrototypeSet _trainingDataSet, int iterations, int n) {
        super(_trainingDataSet);
        this.initialset = true;
        this.initial = InitialSet;
        this.algorithmName = "LVQ";
        this.iterations = iterations;
        this.numberOfPrototypesGenerated = n;
    }

    public LVQGenerator(PrototypeSet _trainingDataSet, int iterations, double percRed) {
        super(_trainingDataSet);
        this.algorithmName = "LVQ";
        this.iterations = iterations;
        this.numberOfPrototypesGenerated = this.getSetSizeFromPercentage(percRed);
    }

    public LVQGenerator(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.algorithmName = "LVQ";
        this.iterations = parameters.getNextAsInt();
        this.numberOfPrototypesGenerated = this.getSetSizeFromPercentage(parameters.getNextAsDouble());
    }

    protected abstract void reward(Prototype var1, Prototype var2);

    protected abstract void penalize(Prototype var1, Prototype var2);

    abstract PrototypeSet initDataSet();

    abstract Prototype extract(PrototypeSet var1);

    abstract void correct(Prototype var1, PrototypeSet var2);

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet outputDataSet = this.initDataSet();
        for (int it = 0; it < this.iterations; ++it) {
            Prototype instance = this.extract(this.trainingDataSet);
            this.correct(instance, outputDataSet);
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(outputDataSet);
        return outputDataSet;
    }
}

