/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.curvefitting.algorithm;

import gov.nih.ncats.ifx.qhts.utils.HillConstants;
import gov.nih.ncats.ifx.qhts.utils.NCGCConstants;
import gov.nih.ncats.ifx.qhts.utils.PlateUtil;

public class CurveClass2 {
    private boolean useMask = true;
    private boolean allowBell = true;
    private double sdPct = 10.0;
    private double sdFactor = 3.0;
    private double robustPct = 6.0 * this.sdPct;
    private double r2Cutoff = HillConstants.R2_CLASS1_CUTOFF;
    private double asymThresh = 0.75;
    private boolean relativeActivity = true;
    private double pvalueCutoff = 0.05;

    public void setSDPct(double sd) {
        this.sdPct = sd;
        this.robustPct = 6.0 * this.sdPct;
    }

    public double calcCurveClass(double[] fitParas, double[] concs, double[] acts, boolean[] maskFlags, double pvalue) throws Exception {
        return this.calcCurveClass(fitParas, 1, concs, acts, maskFlags, pvalue);
    }

    public void setSdFactor(double sdFactor) {
        this.sdFactor = sdFactor;
    }

    public void setRelativeActivity(boolean relativeActivity) {
        this.relativeActivity = relativeActivity;
    }

    public double calcCurveClass(double[] fitParas1, int dn, double[] concs, double[] acts1, boolean[] maskFlags, double pvalue) throws Exception {
        int i;
        double[] fitParas = null;
        double[] acts = null;
        if (NCGCConstants.ACTIVITY_DELTA > 0.0) {
            int i2;
            int no = acts1.length;
            acts = new double[no];
            for (i2 = 0; i2 < no; ++i2) {
                acts[i2] = acts1[i2] - NCGCConstants.ACTIVITY_DELTA;
            }
            if (fitParas1 != null) {
                no = fitParas1.length;
                fitParas = new double[no];
                for (i2 = 0; i2 < no; ++i2) {
                    fitParas[i2] = fitParas1[i2];
                }
                fitParas[1] = fitParas[1] - NCGCConstants.ACTIVITY_DELTA;
                fitParas[6] = fitParas[6] - NCGCConstants.ACTIVITY_DELTA;
            }
        } else if (HillConstants.SHIFT_ACTIVITY && fitParas1 != null) {
            double zeroAct = fitParas1[6];
            int no = acts1.length;
            acts = new double[no];
            for (i = 0; i < no; ++i) {
                acts[i] = acts1[i] - zeroAct;
            }
            no = fitParas1.length;
            fitParas = new double[no];
            for (i = 0; i < no; ++i) {
                fitParas[i] = fitParas1[i];
            }
            fitParas[1] = fitParas[1] - zeroAct;
            fitParas[6] = fitParas[6] - zeroAct;
        } else if (HillConstants.SHIFT_ACTIVITY) {
            int no = acts1.length;
            double median = PlateUtil.calcMedian(acts1);
            acts = new double[no];
            for (i = 0; i < no; ++i) {
                acts[i] = acts1[i] - median;
            }
            fitParas = fitParas1;
        } else {
            int no = acts1.length;
            acts = new double[no];
            for (int i3 = 0; i3 < no; ++i3) {
                acts[i3] = acts1[i3];
            }
            fitParas = fitParas1;
        }
        int no = acts.length;
        double pctCutoff = HillConstants.CLASSIFICATION_SD * HillConstants.CLASSIFICATION_SD_FACTOR;
        double maxAct = -1.7976931348623157E308;
        double minAct = Double.MAX_VALUE;
        for (int i4 = 0; i4 < no; ++i4) {
            double act = acts[i4];
            if (maskFlags != null && !maskFlags[i4]) continue;
            maxAct = Math.max(maxAct, act);
            minAct = Math.min(minAct, act);
        }
        if (HillConstants.AUTO_SUPER_ACTIVE && pvalue > 0.05) {
            int no1 = 0;
            int no2 = 0;
            for (int i5 = 0; i5 < acts.length; ++i5) {
                if (acts[i5] < -this.robustPct) {
                    ++no1;
                }
                if (!(acts[i5] < -6.0 * this.sdPct)) continue;
                ++no2;
            }
            if (1.0 * (double)no1 / (double)acts.length >= HillConstants.SUPER_ACTIVE_RATIO) {
                return -1.01;
            }
            if (1.0 * (double)no2 / (double)acts.length >= HillConstants.SUPER_ACTIVE_RATIO && this.isSuperActive(acts)) {
                return -1.02;
            }
        }
        if (no > 1 && minAct > pctCutoff && maxAct > pctCutoff && maxAct - minAct < pctCutoff) {
            return 5.0;
        }
        if (no > 1 && minAct < -pctCutoff && maxAct < -pctCutoff && maxAct - minAct < pctCutoff) {
            return 5.0;
        }
        if (pvalue > 0.05 && Math.abs(minAct) < pctCutoff && Math.abs(maxAct) < pctCutoff) {
            return 4.0;
        }
        if (fitParas == null) {
            return this.calcCurveClassWithoutFit(fitParas, dn, concs, acts, maskFlags, pvalue);
        }
        return this.calcCurveClassWithFit(fitParas, dn, concs, acts, maskFlags, pvalue);
    }

    public double calcCurveClassWithFit(double[] fitParas, int dn, double[] concs, double[] acts, boolean[] maskFlags, double pvalue) throws Exception {
        return this.calcCurveClassWithFit2(fitParas, dn, concs, acts, maskFlags, pvalue);
    }

    public double calcCurveClassWithoutFit(double[] fitParas, double[] concs, double[] acts, boolean[] maskFlags, double pvalue) throws Exception {
        return this.calcCurveClassWithoutFit(fitParas, 1, concs, acts, maskFlags, pvalue);
    }

    public double calcCurveClassWithFit1(double[] fitParas, int dn, double[] concs, double[] acts, boolean[] maskFlags, double pvalue) throws Exception {
        int sign;
        double pctCutoff = this.sdPct * this.sdFactor;
        double ac50 = fitParas[0];
        double zeroAct = fitParas[6];
        double infAct = fitParas[1];
        double r2 = fitParas[3];
        if (Math.abs(zeroAct - infAct) < HillConstants.RANGE_CUTOFF * this.sdPct) {
            return 4.0;
        }
        int n = sign = zeroAct < infAct ? 1 : -1;
        if (Math.abs(zeroAct) > 6.0 * this.sdPct) {
            return 5.0;
        }
        if (zeroAct > infAct && 0.5 * (zeroAct + infAct) > pctCutoff) {
            return 5.0;
        }
        if (zeroAct < infAct && 0.5 * (zeroAct + infAct) < -pctCutoff) {
            return 5.0;
        }
        int no = acts.length;
        if (this.relativeActivity && pvalue < 0.05 && Math.abs(zeroAct) > this.sdPct) {
            for (int i = 0; i < no; ++i) {
                acts[i] = acts[i] - zeroAct;
            }
            infAct -= zeroAct;
            zeroAct = 0.0;
        }
        double maxAct = -1.7976931348623157E308;
        double minAct = Double.MAX_VALUE;
        int uSDF = 0;
        int uSD = 0;
        int dSD = 0;
        int dSDF = 0;
        int lastPoint = -1;
        double lastAct = 0.0;
        double lastAct2 = 0.0;
        for (int i = 0; i < no; ++i) {
            double act = acts[i];
            if (this.useMask && maskFlags != null && !maskFlags[i]) continue;
            lastAct2 = lastAct;
            lastAct = act;
            lastPoint = i;
            maxAct = Math.max(maxAct, act);
            minAct = Math.min(minAct, act);
            if (act > this.sdPct) {
                ++uSD;
                if (!(act > pctCutoff)) continue;
                ++uSDF;
                continue;
            }
            if (!(act < -this.sdPct)) continue;
            ++dSD;
            if (!(act < -pctCutoff)) continue;
            ++dSDF;
        }
        int pts = 0;
        for (int i = 0; i < no; ++i) {
            if (this.useMask && maskFlags != null && !maskFlags[i] || !(concs[i] > ac50) || !((double)sign * acts[i] > this.asymThresh * (double)sign * infAct)) continue;
            ++pts;
        }
        if (pts >= 2) {
            if (pvalue < this.pvalueCutoff) {
                if (sign > 0) {
                    if (maxAct >= this.robustPct) {
                        return 1.1;
                    }
                    if (maxAct >= pctCutoff) {
                        return 1.2;
                    }
                    if (maxAct >= HillConstants.C124_FACTOR * this.sdPct) {
                        return 1.4;
                    }
                } else {
                    if (minAct <= -this.robustPct) {
                        return -1.1;
                    }
                    if (minAct <= -pctCutoff) {
                        return -1.2;
                    }
                    if (minAct <= -HillConstants.C124_FACTOR * this.sdPct) {
                        return -1.4;
                    }
                }
            } else if (sign > 0) {
                if (maxAct >= this.robustPct) {
                    return 1.3;
                }
                if (maxAct >= pctCutoff) {
                    return 1.4;
                }
            } else {
                if (minAct <= -this.robustPct) {
                    return -1.3;
                }
                if (minAct <= -pctCutoff) {
                    return -1.4;
                }
            }
        }
        if (sign > 0 && uSDF == 1 && lastPoint > 0 && maxAct == lastAct && lastAct2 < this.sdPct) {
            return 3.0;
        }
        if (sign < 0 && dSDF == 1 && lastPoint > 0 && minAct == lastAct && lastAct2 > -this.sdPct) {
            return -3.0;
        }
        if (pvalue < this.pvalueCutoff) {
            if (sign > 0) {
                if (Math.min(maxAct, infAct) >= this.robustPct) {
                    return 2.1;
                }
                if (Math.min(maxAct, infAct) >= pctCutoff) {
                    return 2.2;
                }
                if (Math.min(maxAct, infAct) >= HillConstants.C124_FACTOR * this.sdPct) {
                    return 2.4;
                }
            } else {
                if (Math.max(minAct, infAct) <= -this.robustPct) {
                    return -2.1;
                }
                if (Math.max(minAct, infAct) <= -pctCutoff) {
                    return -2.2;
                }
                if (Math.max(minAct, infAct) <= -HillConstants.C124_FACTOR * this.sdPct) {
                    return -2.4;
                }
            }
        } else if (sign > 0) {
            if (Math.min(maxAct, infAct) >= this.robustPct) {
                return 2.3;
            }
            if (Math.min(maxAct, infAct) >= pctCutoff) {
                return 2.4;
            }
        } else {
            if (Math.max(minAct, infAct) <= -this.robustPct) {
                return -2.3;
            }
            if (Math.max(minAct, infAct) <= -pctCutoff) {
                return -2.4;
            }
        }
        return 4.0;
    }

    public double calcCurveClassWithFit2(double[] fitParas, int dn, double[] concs, double[] acts, boolean[] maskFlags, double pvalue) throws Exception {
        int sign;
        double pctCutoff = HillConstants.CLASSIFICATION_SD * HillConstants.CLASSIFICATION_SD_FACTOR;
        double ac50 = fitParas[0];
        double zeroAct = fitParas[6];
        double infAct = fitParas[1];
        double r2 = fitParas[3];
        if (Math.abs(zeroAct - infAct) < HillConstants.RANGE_CUTOFF * this.sdPct) {
            return 4.0;
        }
        int n = sign = zeroAct < infAct ? 1 : -1;
        if (Math.abs(zeroAct) > 6.0 * this.sdPct) {
            return 5.0;
        }
        if (zeroAct > infAct && 0.5 * (zeroAct + infAct) > pctCutoff) {
            return 5.0;
        }
        if (zeroAct < infAct && 0.5 * (zeroAct + infAct) < -pctCutoff) {
            return 5.0;
        }
        int no = acts.length;
        if (this.relativeActivity && pvalue < 0.05 && Math.abs(zeroAct) > this.sdPct) {
            for (int i = 0; i < no; ++i) {
                acts[i] = acts[i] - zeroAct;
            }
            infAct -= zeroAct;
            zeroAct = 0.0;
        }
        double maxAct = -1.7976931348623157E308;
        double minAct = Double.MAX_VALUE;
        int uSDF = 0;
        int uSD = 0;
        int dSD = 0;
        int dSDF = 0;
        int lastPoint = -1;
        double lastAct = 0.0;
        double lastAct2 = 0.0;
        for (int i = 0; i < no; ++i) {
            double act = acts[i];
            if (this.useMask && maskFlags != null && !maskFlags[i]) continue;
            lastAct2 = lastAct;
            lastAct = act;
            lastPoint = i;
            maxAct = Math.max(maxAct, act);
            minAct = Math.min(minAct, act);
            if (act > this.sdPct) {
                ++uSD;
                if (!(act > pctCutoff)) continue;
                ++uSDF;
                continue;
            }
            if (!(act < -this.sdPct)) continue;
            ++dSD;
            if (!(act < -pctCutoff)) continue;
            ++dSDF;
        }
        int pts = 0;
        for (int i = 0; i < no; ++i) {
            if (this.useMask && maskFlags != null && !maskFlags[i] || !(concs[i] > ac50) || !((double)sign * acts[i] > this.asymThresh * (double)sign * infAct)) continue;
            ++pts;
        }
        if (pts >= 2) {
            if (pvalue < this.pvalueCutoff) {
                if (sign > 0) {
                    if (Math.min(maxAct, infAct) >= this.robustPct) {
                        return 1.1;
                    }
                    if (Math.min(maxAct, infAct) >= pctCutoff) {
                        return 1.2;
                    }
                    if (Math.min(maxAct, infAct) >= HillConstants.C124_FACTOR * this.sdPct) {
                        return 1.4;
                    }
                } else {
                    if (Math.max(minAct, infAct) <= -this.robustPct) {
                        return -1.1;
                    }
                    if (Math.max(minAct, infAct) <= -pctCutoff) {
                        return -1.2;
                    }
                    if (Math.max(minAct, infAct) <= -HillConstants.C124_FACTOR * this.sdPct) {
                        return -1.4;
                    }
                }
            } else if (sign > 0) {
                if (Math.min(maxAct, infAct) >= this.robustPct) {
                    return 1.3;
                }
                if (Math.min(maxAct, infAct) >= pctCutoff) {
                    return 1.4;
                }
            } else {
                if (Math.max(minAct, infAct) <= -this.robustPct) {
                    return -1.3;
                }
                if (Math.max(minAct, infAct) <= -pctCutoff) {
                    return -1.4;
                }
            }
        }
        if (sign > 0 && uSDF == 1 && lastPoint > 0 && maxAct == lastAct && lastAct2 < this.sdPct) {
            return 3.0;
        }
        if (sign < 0 && dSDF == 1 && lastPoint > 0 && minAct == lastAct && lastAct2 > -this.sdPct) {
            return -3.0;
        }
        if (pvalue < this.pvalueCutoff) {
            if (sign > 0) {
                if (Math.min(maxAct, infAct) >= this.robustPct) {
                    return 2.1;
                }
                if (Math.min(maxAct, infAct) >= pctCutoff) {
                    return 2.2;
                }
                if (Math.min(maxAct, infAct) >= HillConstants.C124_FACTOR * this.sdPct) {
                    return 2.4;
                }
            } else {
                if (Math.max(minAct, infAct) <= -this.robustPct) {
                    return -2.1;
                }
                if (Math.max(minAct, infAct) <= -pctCutoff) {
                    return -2.2;
                }
                if (Math.max(minAct, infAct) <= -HillConstants.C124_FACTOR * this.sdPct) {
                    return -2.4;
                }
            }
        } else if (sign > 0) {
            if (Math.min(maxAct, infAct) >= this.robustPct) {
                return 2.3;
            }
            if (Math.min(maxAct, infAct) >= pctCutoff) {
                return 2.4;
            }
        } else {
            if (Math.max(minAct, infAct) <= -this.robustPct) {
                return -2.3;
            }
            if (Math.max(minAct, infAct) <= -pctCutoff) {
                return -2.4;
            }
        }
        return 4.0;
    }

    public double calcCurveClassWithoutFit(double[] fitParas, int dn, double[] concs, double[] acts, boolean[] maskFlags, double pvalue) throws Exception {
        int no = acts.length;
        double median = PlateUtil.calcMedian(acts);
        if (Math.abs(median) > 6.0 * this.sdPct) {
            return 5.0;
        }
        double pctCutoff = this.sdPct * this.sdFactor;
        double maxAct = -1.7976931348623157E308;
        double minAct = Double.MAX_VALUE;
        int uSDF = 0;
        int uSD = 0;
        int dSD = 0;
        int dSDF = 0;
        int lastPoint = -1;
        double lastAct = 0.0;
        double lastAct2 = 0.0;
        for (int i = 0; i < no; ++i) {
            double act = acts[i];
            if (this.useMask && maskFlags != null && !maskFlags[i]) continue;
            lastAct2 = lastAct;
            lastAct = act;
            lastPoint = i;
            maxAct = Math.max(maxAct, act);
            minAct = Math.min(minAct, act);
            if (act > this.sdPct) {
                ++uSD;
                if (!(act > pctCutoff)) continue;
                ++uSDF;
                continue;
            }
            if (!(act < -this.sdPct)) continue;
            ++dSD;
            if (!(act < -pctCutoff)) continue;
            ++dSDF;
        }
        int sign = 0;
        sign = maxAct < pctCutoff && minAct < -pctCutoff ? -1 : (maxAct > pctCutoff && minAct > -pctCutoff ? 1 : (uSDF > dSDF ? 1 : (dSDF > uSDF ? -1 : (uSD > dSD ? 1 : -1))));
        if (dn > 1) {
            int delta = concs.length / dn;
            double maxc = -10.0;
            double minc = 10.0;
            for (int i = 0; i < dn; ++i) {
                double[] xx = new double[delta];
                double[] yy = new double[delta];
                for (int j = 0; j < delta; ++j) {
                    xx[j] = concs[j * dn + i];
                    yy[j] = acts[j * dn + i];
                }
                double cc = this.calcCurveClassWithoutFit(fitParas, 1, xx, yy, maskFlags, pvalue);
                maxc = Math.max(maxc, cc);
                minc = Math.min(minc, cc);
            }
            if (sign > 0) {
                return minc;
            }
            return maxc;
        }
        if (sign > 0 && uSDF == 1 && maxAct == lastAct) {
            return 3.0;
        }
        if (sign < 0 && dSDF == 1 && minAct == lastAct) {
            return -3.0;
        }
        return 4.0;
    }

    public boolean isSuperActive(double[] ys) {
        int i;
        boolean flag1 = true;
        boolean flag2 = true;
        for (i = 1; i < ys.length; ++i) {
            if (!(ys[i] > ys[0])) continue;
            flag1 = false;
            break;
        }
        for (i = 2; i < ys.length; ++i) {
            if (!(ys[i] > ys[1])) continue;
            flag2 = false;
            break;
        }
        return !flag1 || !flag2;
    }
}

