/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.ge;

import cc.mallet.classify.constraints.ge.MaxEntGEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.BitSet;

public abstract class MaxEntFLGEConstraints
implements MaxEntGEConstraint {
    protected boolean useValues;
    protected int numLabels;
    protected int numFeatures;
    protected IntObjectHashMap<MaxEntFLGEConstraint> constraints;
    protected IntArrayList indexCache;
    protected DoubleArrayList valueCache;

    public MaxEntFLGEConstraints(int numFeatures, int numLabels, boolean useValues) {
        this.numFeatures = numFeatures;
        this.numLabels = numLabels;
        this.useValues = useValues;
        this.constraints = new IntObjectHashMap();
        this.indexCache = new IntArrayList();
        this.valueCache = new DoubleArrayList();
    }

    public abstract void addConstraint(int var1, double[] var2, double var3);

    @Override
    public double getCompositeConstraintFeatureValue(FeatureVector input, int label) {
        double value = 0.0;
        for (int i = 0; i < this.indexCache.size(); ++i) {
            if (this.useValues) {
                value += this.constraints.get(this.indexCache.get(i)).getValue(label) * this.valueCache.get(i);
                continue;
            }
            value += this.constraints.get(this.indexCache.get(i)).getValue(label);
        }
        return value;
    }

    @Override
    public void computeExpectations(FeatureVector input, double[] dist, double weight) {
        this.preProcess(input);
        for (int li = 0; li < this.numLabels; ++li) {
            double p = weight * dist[li];
            for (int i = 0; i < this.indexCache.size(); ++i) {
                if (this.useValues) {
                    int n = li;
                    this.constraints.get((int)this.indexCache.get((int)i)).expectation[n] = this.constraints.get((int)this.indexCache.get((int)i)).expectation[n] + p * this.valueCache.get(i);
                    continue;
                }
                int n = li;
                this.constraints.get((int)this.indexCache.get((int)i)).expectation[n] = this.constraints.get((int)this.indexCache.get((int)i)).expectation[n] + p;
            }
        }
    }

    @Override
    public void zeroExpectations() {
        for (ObjectCursor cursor : this.constraints.values()) {
            ((MaxEntFLGEConstraint)cursor.value).expectation = new double[this.numLabels];
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        int ii = 0;
        BitSet bitSet = new BitSet(data.size());
        for (Instance instance : data) {
            double weight = data.getInstanceWeight(instance);
            FeatureVector fv = (FeatureVector)instance.getData();
            for (int loc = 0; loc < fv.numLocations(); ++loc) {
                int fi = fv.indexAtLocation(loc);
                if (!this.constraints.containsKey(fi)) continue;
                this.constraints.get((int)fi).count = this.useValues ? (this.constraints.get((int)fi).count += weight * fv.valueAtLocation(loc)) : (this.constraints.get((int)fi).count += weight);
                bitSet.set(ii);
            }
            ++ii;
            if (!this.constraints.containsKey(this.numFeatures)) continue;
            bitSet.set(ii);
            this.constraints.get((int)this.numFeatures).count += weight;
        }
        return bitSet;
    }

    @Override
    public void preProcess(FeatureVector input) {
        this.indexCache.clear();
        if (this.useValues) {
            this.valueCache.clear();
        }
        for (int loc = 0; loc < input.numLocations(); ++loc) {
            int fi = input.indexAtLocation(loc);
            if (!this.constraints.containsKey(fi)) continue;
            this.indexCache.add(fi);
            if (!this.useValues) continue;
            this.valueCache.add(input.valueAtLocation(loc));
        }
        if (this.constraints.containsKey(this.numFeatures)) {
            this.indexCache.add(this.numFeatures);
            if (this.useValues) {
                this.valueCache.add(1.0);
            }
        }
    }

    protected abstract class MaxEntFLGEConstraint {
        protected double[] target;
        protected double[] expectation;
        protected double count;
        protected double weight;

        public MaxEntFLGEConstraint(double[] target, double weight) {
            this.target = target;
            this.weight = weight;
            this.expectation = null;
            this.count = 0.0;
        }

        public double[] getTarget() {
            return this.target;
        }

        public double[] getExpectation() {
            return this.expectation;
        }

        public double getCount() {
            return this.count;
        }

        public double getWeight() {
            return this.weight;
        }

        public abstract double getValue(int var1);
    }
}

