/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class OlsComputer
implements Ols.Processor {
    @Override
    public LeastSquaresResults compute(LinearModel model) {
        try {
            DoubleSeq y = model.getY();
            if (y.norm2() < Constants.getEpsilon()) {
                return null;
            }
            if (model.getVariablesCount() > 0) {
                FastMatrix x = model.variables();
                QRLeastSquaresSolution solution = QRLeastSquaresSolver.robustLeastSquares(y, x);
                FastMatrix bvar = solution.unscaledCovariance();
                return LeastSquaresResults.builder(y, x).mean(model.isMeanCorrection()).estimation(solution.getB(), bvar).ssq(solution.getSsqErr()).residuals(solution.getE()).build();
            }
            return LeastSquaresResults.builder(y, null).mean(model.isMeanCorrection()).ssq(y.ssq()).residuals(y).build();
        }
        catch (MatrixException err) {
            throw new EcoException("Ols failed");
        }
    }
}

