/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

class TetherRecordReader
implements RecordReader<TetherData, NullWritable> {
    private FsInput in;
    private DataFileReader reader;
    private long start;
    private long end;

    public TetherRecordReader(JobConf job, FileSplit split) throws IOException {
        this.in = new FsInput(split.getPath(), job);
        this.reader = new DataFileReader(this.in, new GenericDatumReader());
        this.reader.sync(split.getStart());
        this.start = this.in.tell();
        this.end = split.getStart() + split.getLength();
        job.set("avro.input.schema", this.reader.getSchema().toString());
    }

    public Schema getSchema() {
        return this.reader.getSchema();
    }

    @Override
    public TetherData createKey() {
        return new TetherData();
    }

    @Override
    public NullWritable createValue() {
        return NullWritable.get();
    }

    @Override
    public boolean next(TetherData data, NullWritable ignore) throws IOException {
        if (!this.reader.hasNext() || this.reader.pastSync(this.end)) {
            return false;
        }
        data.buffer(this.reader.nextBlock());
        data.count((int)this.reader.getBlockCount());
        return true;
    }

    @Override
    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.tell() - this.start) / (float)(this.end - this.start));
    }

    @Override
    public long getPos() throws IOException {
        return this.in.tell();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

