/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql.parser;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.Compiler;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ClassDescriptor;

class CompiledExpression
implements EJBQLCompiledExpression {
    private String source;
    private String rootId;
    private Map<String, ClassDescriptor> descriptorsById;
    private Map<String, ObjRelationship> incomingById;
    private EJBQLExpression expression;
    private SQLResult result;
    private PrefetchTreeNode prefetchTree;

    CompiledExpression() {
    }

    @Override
    public ClassDescriptor getEntityDescriptor(String idVariable) {
        if (idVariable == null) {
            return null;
        }
        return this.descriptorsById.get(Compiler.normalizeIdPath(idVariable));
    }

    @Override
    public SQLResult getResult() {
        return this.result;
    }

    @Override
    public ClassDescriptor getRootDescriptor() {
        return this.rootId != null ? this.getEntityDescriptor(this.rootId) : null;
    }

    @Override
    public List<DbRelationship> getIncomingRelationships(String identifier) {
        ObjRelationship relationship = this.incomingById.get(identifier);
        if (relationship == null) {
            return Collections.emptyList();
        }
        return relationship.getDbRelationships();
    }

    @Override
    public EJBQLExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    void setExpression(EJBQLExpression expression) {
        this.expression = expression;
    }

    void setDescriptorsById(Map<String, ClassDescriptor> descriptorsById) {
        this.descriptorsById = descriptorsById;
    }

    void setIncomingById(Map<String, ObjRelationship> incomingById) {
        this.incomingById = incomingById;
    }

    void setSource(String source) {
        this.source = source;
    }

    void setRootId(String rootId) {
        this.rootId = rootId;
    }

    void setResult(SQLResult resultSetMapping) {
        this.result = resultSetMapping;
    }

    @Override
    public PrefetchTreeNode getPrefetchTree() {
        return this.prefetchTree;
    }

    public void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        this.prefetchTree = prefetchTree;
    }
}

