/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.engine.execution.ConstructorInvocation;
import org.junit.jupiter.engine.execution.InvocationInterceptorChain;
import org.junit.jupiter.engine.execution.MethodInvocation;
import org.junit.jupiter.engine.execution.ParameterResolutionUtils;
import org.junit.jupiter.engine.extension.ExtensionRegistry;

@API(status=API.Status.INTERNAL, since="5.0")
public class InterceptingExecutableInvoker {
    private static final InvocationInterceptorChain interceptorChain = new InvocationInterceptorChain();

    public <T> T invoke(Constructor<T> constructor, Optional<Object> outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry, ReflectiveInterceptorCall<Constructor<T>, T> interceptorCall) {
        Object[] arguments = ParameterResolutionUtils.resolveParameters(constructor, Optional.empty(), outerInstance, extensionContext, extensionRegistry);
        ConstructorInvocation<T> invocation = new ConstructorInvocation<T>(constructor, arguments);
        return this.invoke(invocation, invocation, extensionContext, extensionRegistry, interceptorCall);
    }

    public <T> T invoke(Method method, Object target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry, ReflectiveInterceptorCall<Method, T> interceptorCall) {
        Optional<Object> optionalTarget = target instanceof Optional ? (Optional<Object>)target : Optional.ofNullable(target);
        Object[] arguments = ParameterResolutionUtils.resolveParameters(method, optionalTarget, extensionContext, extensionRegistry);
        MethodInvocation invocation = new MethodInvocation(method, optionalTarget, arguments);
        return this.invoke(invocation, invocation, extensionContext, extensionRegistry, interceptorCall);
    }

    private <E extends Executable, T> T invoke(InvocationInterceptor.Invocation<T> originalInvocation, ReflectiveInvocationContext<E> invocationContext, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry, ReflectiveInterceptorCall<E, T> call) {
        return (T)interceptorChain.invoke(originalInvocation, extensionRegistry, (interceptor, wrappedInvocation) -> call.apply(interceptor, wrappedInvocation, invocationContext, extensionContext));
    }

    public static interface ReflectiveInterceptorCall<E extends Executable, T> {
        public T apply(InvocationInterceptor var1, InvocationInterceptor.Invocation<T> var2, ReflectiveInvocationContext<E> var3, ExtensionContext var4) throws Throwable;

        public static ReflectiveInterceptorCall<Method, Void> ofVoidMethod(VoidMethodInterceptorCall call) {
            return (interceptorChain, invocation, invocationContext, extensionContext) -> {
                call.apply(interceptorChain, invocation, invocationContext, extensionContext);
                return null;
            };
        }

        public static interface VoidMethodInterceptorCall {
            public void apply(InvocationInterceptor var1, InvocationInterceptor.Invocation<Void> var2, ReflectiveInvocationContext<Method> var3, ExtensionContext var4) throws Throwable;
        }
    }
}

