/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.net.URI;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicMessages {
    TestBasicMessages() {
    }

    @Test
    void testDefaultResponseConstructors() {
        BasicHttpResponse response1 = new BasicHttpResponse(400, "Bad Request");
        Assertions.assertEquals((int)400, (int)response1.getCode());
        BasicHttpResponse response2 = new BasicHttpResponse(500, "whatever");
        Assertions.assertEquals((int)500, (int)response2.getCode());
        Assertions.assertEquals((Object)"whatever", (Object)response2.getReasonPhrase());
    }

    @Test
    void testSetResponseStatus() {
        BasicHttpResponse response1 = new BasicHttpResponse(200, "OK");
        Assertions.assertEquals((int)200, (int)response1.getCode());
        BasicHttpResponse response2 = new BasicHttpResponse(400, "Bad Request");
        Assertions.assertEquals((int)400, (int)response2.getCode());
        BasicHttpResponse response3 = new BasicHttpResponse(500, "whatever");
        Assertions.assertEquals((int)500, (int)response3.getCode());
        Assertions.assertEquals((Object)"whatever", (Object)response3.getReasonPhrase());
        BasicHttpResponse response4 = new BasicHttpResponse(200, "OK");
        Assertions.assertThrows(IllegalArgumentException.class, () -> TestBasicMessages.lambda$testSetResponseStatus$0((HttpResponse)response4));
    }

    @Test
    void testDefaultRequestConstructors() {
        BasicHttpRequest request1 = new BasicHttpRequest("WHATEVER", "/");
        Assertions.assertEquals((Object)"WHATEVER", (Object)request1.getMethod());
        Assertions.assertEquals((Object)"/", (Object)request1.getPath());
        BasicHttpRequest request2 = new BasicHttpRequest(Method.GET, "/");
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request2.getMethod());
        Assertions.assertEquals((Object)"/", (Object)request2.getPath());
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpRequest(Method.GET, (URI)null));
    }

    @Test
    void testResponseBasics() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertEquals((Object)"OK", (Object)response.getReasonPhrase());
    }

    @Test
    void testResponseStatusLineMutation() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertEquals((Object)"OK", (Object)response.getReasonPhrase());
        response.setReasonPhrase("Kind of OK");
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertEquals((Object)"Kind of OK", (Object)response.getReasonPhrase());
        response.setCode(299);
        Assertions.assertEquals((int)299, (int)response.getCode());
        Assertions.assertNull((Object)response.getReasonPhrase());
    }

    @Test
    void testResponseInvalidStatusCode() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BasicHttpResponse(-200, "OK"));
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertThrows(IllegalArgumentException.class, () -> response.setCode(-1));
    }

    @Test
    void testRequestBasics() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "/stuff");
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertNull((Object)request.getAuthority());
        Assertions.assertEquals((Object)new URI("/stuff"), (Object)request.getUri());
    }

    @Test
    void testRequestWithRelativeURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("/stuff"));
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertNull((Object)request.getAuthority());
        Assertions.assertEquals((Object)new URI("/stuff"), (Object)request.getUri());
    }

    @Test
    void testRequestWithAbsoluteURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("https://host:9443/stuff?param=value"));
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff?param=value", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("host", 9443), (Object)request.getAuthority());
        Assertions.assertEquals((Object)"https", (Object)request.getScheme());
        Assertions.assertEquals((Object)new URI("https://host:9443/stuff?param=value"), (Object)request.getUri());
    }

    @Test
    void testRequestWithAbsoluteURIAsPath() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "https://host:9443/stuff?param=value");
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff?param=value", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("host", 9443), (Object)request.getAuthority());
        Assertions.assertEquals((Object)"https", (Object)request.getScheme());
        Assertions.assertEquals((Object)new URI("https://host:9443/stuff?param=value"), (Object)request.getUri());
    }

    @Test
    void testRequestWithNoPath() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("http://host"));
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("host"), (Object)request.getAuthority());
        Assertions.assertEquals((Object)"http", (Object)request.getScheme());
        Assertions.assertEquals((Object)new URI("http://host/"), (Object)request.getUri());
    }

    @Test
    void testRequestWithUserInfo() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("https://user:pwd@host:9443/stuff?param=value"));
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff?param=value", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("user:pwd", "host", 9443), (Object)request.getAuthority());
        Assertions.assertEquals((Object)"https", (Object)request.getScheme());
        Assertions.assertEquals((Object)new URI("https://host:9443/stuff?param=value"), (Object)request.getUri());
    }

    @Test
    void testRequestWithAuthority() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new HttpHost("http", "somehost", -1), "/stuff");
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("somehost"), (Object)request.getAuthority());
        Assertions.assertEquals((Object)new URI("http://somehost/stuff"), (Object)request.getUri());
    }

    @Test
    void testRequestWithAuthorityRelativePath() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new HttpHost("http", "somehost", -1), "stuff");
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"stuff", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("somehost"), (Object)request.getAuthority());
        Assertions.assertEquals((Object)new URI("http://somehost/stuff"), (Object)request.getUri());
    }

    @Test
    void testRequestHostWithReservedChars() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, URI.create("http://someuser%21@%21example%21.com/stuff"));
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertEquals((Object)new URIAuthority("someuser%21", "%21example%21.com", -1), (Object)request.getAuthority());
        Assertions.assertEquals((Object)new URI("http://%21example%21.com/stuff"), (Object)request.getUri());
    }

    @Test
    void testRequestAbsoluteRequestUri() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new HttpHost("http", "somehost", -1), "stuff");
        Assertions.assertEquals((Object)"stuff", (Object)request.getRequestUri());
        request.setAbsoluteRequestUri(true);
        Assertions.assertEquals((Object)"http://somehost/stuff", (Object)request.getRequestUri());
    }

    @Test
    void testModifyingExistingRequest() throws Exception {
        URI uri = URI.create("https://example.org");
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, uri);
        URI newUri = new URIBuilder(request.getUri()).addParameter("name", "value").build();
        request.setUri(newUri);
        Assertions.assertEquals((Object)newUri, (Object)request.getUri());
    }

    private static /* synthetic */ void lambda$testSetResponseStatus$0(HttpResponse response4) throws Throwable {
        response4.setCode(-23);
    }
}

