/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/**
 * A mechanism that broadcasts to all registered consumers. It is mainly used for testing.
 */
public class InMemoryBroadcaster implements Broadcaster {
    
    public static final InMemoryBroadcaster INSTANCE = new InMemoryBroadcaster();
    
    private final ArrayList<Listener> listeners = new ArrayList<Listener>();

    @Override
    public void send(ByteBuffer buff) {
        int start = buff.position();
        for (Listener l : listeners) {
            ((Buffer)buff).position(start);
            l.receive(buff);
        }
    }

    @Override
    public void addListener(Listener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeListener(Listener listener) {
        listeners.remove(listener);
    }

    @Override
    public void close() {
        // ignore
    }
    
    @Override
    public void setBroadcastConfig(DynamicBroadcastConfig broadcastConfig) {
        // not yet implemented
    }

}
