/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.sys.JenaSystem;

public class Cmds {
    private static Map<String, Consumer<String[]>> cmds;

    static void init() {
        if (cmds == null) {
            cmds = new HashMap<String, Consumer<String[]>>();
        }
    }

    public static void injectCmd(String name, Consumer<String[]> main) {
        cmds.put(name, main);
    }

    public static Consumer<String[]> findCmd(String name) {
        return cmds.get(name);
    }

    public static void exec(String cmdName, String ... args) {
        try {
            JenaSystem.init();
        }
        catch (NoClassDefFoundError ex) {
            System.err.println("NoClassDefFoundError: Class missing on the classpath/modulepath: " + ex.getMessage().replace('/', '.'));
            throw new CmdException("NoClassDefFoundError: " + ex.getMessage(), ex);
        }
        Consumer<String[]> main = Cmds.findCmd(cmdName);
        if (main == null) {
            System.err.println("Command " + cmdName + " not found");
            return;
        }
        main.accept(args);
    }

    static {
        JenaSystem.init();
    }
}

