/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.jena.rfc3986.IRI;
import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.RFC3986;

public class AlgResolveIRI {
    public static IRI3986 resolve(IRI base, IRI reference) {
        return AlgResolveIRI.transformReferencesNonStrict(reference, base);
    }

    private static IRI3986 transformReferencesStrict(IRI reference, IRI base) {
        if (reference.hasScheme()) {
            return RFC3986.create(reference);
        }
        return AlgResolveIRI.transformReferencesNonStrict(reference, base);
    }

    private static IRI3986 transformReferencesNonStrict(IRI reference, IRI base) {
        String t_scheme = null;
        String t_authority = "";
        String t_path = "";
        String t_query = null;
        String t_fragment = null;
        boolean sameScheme = Objects.equals(reference.scheme(), base.scheme());
        if (reference.hasScheme() && !sameScheme) {
            t_scheme = reference.scheme();
            t_authority = reference.authority();
            t_path = AlgResolveIRI.remove_dot_segments(reference.path());
            t_query = reference.query();
        } else {
            if (reference.hasAuthority()) {
                t_authority = reference.authority();
                t_path = AlgResolveIRI.remove_dot_segments(reference.path());
                t_query = reference.query();
            } else {
                if (reference.path().isEmpty()) {
                    t_path = base.path();
                    t_query = reference.hasQuery() ? reference.query() : base.query();
                } else {
                    if (reference.path().startsWith("/")) {
                        t_path = AlgResolveIRI.remove_dot_segments(reference.path());
                    } else {
                        t_path = AlgResolveIRI.merge(base, reference.path());
                        t_path = AlgResolveIRI.remove_dot_segments(t_path);
                    }
                    t_query = reference.query();
                }
                t_authority = base.authority();
            }
            t_scheme = base.scheme();
        }
        t_fragment = reference.fragment();
        return RFC3986.newBuilder().scheme(t_scheme).authority(t_authority).path(t_path).query(t_query).fragment(t_fragment).build();
    }

    private static String merge(IRI base, String ref) {
        if (base.hasAuthority() && base.path().isEmpty()) {
            if (ref.startsWith("/")) {
                return ref;
            }
            return "/" + ref;
        }
        String path = base.path();
        int j = path.lastIndexOf(47);
        if (j < 0) {
            return ref;
        }
        return path.substring(0, j) + "/" + ref;
    }

    static String remove_dot_segments(String path) {
        String s1 = AlgResolveIRI.remove_dot_segments$(path);
        return s1;
    }

    private static String remove_dot_segments$(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        if (path.equals("/")) {
            return "/";
        }
        String[] segments = path.split("/");
        int N = segments.length;
        if (N == 0) {
            return path;
        }
        boolean initialSlash = segments[0].isEmpty();
        boolean trailingSlash = false;
        if (N > 1) {
            if (segments[N - 1].equals(".") || segments[N - 1].equals("..")) {
                trailingSlash = true;
            } else if (path.charAt(path.length() - 1) == '/') {
                trailingSlash = true;
            }
        }
        block0: for (int j = 0; j < N; ++j) {
            String s = segments[j];
            if (s.equals(".")) {
                segments[j] = null;
            }
            if (!s.equals("..")) continue;
            segments[j] = null;
            if (j < 1) continue;
            for (int j2 = j - 1; j2 >= 0; --j2) {
                if (segments[j2] == null) continue;
                segments[j2] = null;
                continue block0;
            }
        }
        StringJoiner joiner = new StringJoiner("/");
        if (initialSlash) {
            joiner.add("");
        }
        for (int k = 0; k < segments.length; ++k) {
            if (segments[k] == null || k == 0 && segments[k].isEmpty()) continue;
            joiner.add(segments[k]);
        }
        if (trailingSlash) {
            joiner.add("");
        }
        String s = joiner.toString();
        return s;
    }

    public static IRI3986 relativize(IRI base, IRI iri) {
        String targetPath;
        Objects.requireNonNull(iri);
        if (!base.hasScheme()) {
            return null;
        }
        if (base.hasQuery()) {
            return null;
        }
        if (!iri.hasScheme() || !iri.hasAuthority()) {
            return null;
        }
        if (!Objects.equals(iri.scheme(), base.scheme())) {
            return null;
        }
        if (!Objects.equals(iri.authority(), base.authority())) {
            return null;
        }
        String basePath = base.path();
        String relPath = AlgResolveIRI.relativePath(basePath, targetPath = iri.path(), true);
        if (relPath == null) {
            relPath = targetPath;
        }
        IRI3986 relIRI = IRI3986.build(null, null, relPath, iri.query(), iri.fragment());
        return relIRI;
    }

    private static String relativePath(String basePath, String targetPath, boolean withParentPath) {
        int j;
        if (basePath.equals(targetPath)) {
            return "";
        }
        int idx = basePath.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        String basePrefix = basePath.substring(0, idx + 1);
        boolean targetPathEndsInSlash = targetPath.endsWith("/");
        if (targetPath.startsWith(basePrefix)) {
            String relPath = targetPath.substring(basePrefix.length());
            if (targetPathEndsInSlash && relPath.isEmpty()) {
                return ".";
            }
            relPath = AlgResolveIRI.safeInitalSegment(relPath);
            return relPath;
        }
        if (!withParentPath) {
            return null;
        }
        String[] baseSegs = basePrefix.split("/");
        if (baseSegs.length == 2) {
            return null;
        }
        String[] targetSegs = targetPath.split("/");
        int n = Math.min(baseSegs.length, targetSegs.length);
        for (j = 0; j < n && Objects.equals(baseSegs[j], targetSegs[j]); ++j) {
        }
        if (j == targetSegs.length && j == baseSegs.length && !targetPathEndsInSlash) {
            return "../" + targetSegs[targetSegs.length - 1];
        }
        if (j + 1 == baseSegs.length) {
            if (j == targetSegs.length) {
                if (targetPathEndsInSlash) {
                    return "..";
                }
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("..");
            for (int k = j; k < targetSegs.length; ++k) {
                sb.append("/");
                sb.append(targetSegs[k]);
            }
            if (targetPathEndsInSlash) {
                sb.append("/");
            }
            return sb.toString();
        }
        return null;
    }

    public static String safeInitalSegment(String relPath) {
        int rColon = ((String)relPath).indexOf(58);
        if (rColon < 0) {
            return relPath;
        }
        int rPathSep = ((String)relPath).indexOf(47);
        if (rPathSep < 0 || rColon < rPathSep) {
            relPath = "./" + (String)relPath;
        }
        return relPath;
    }
}

