/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.http.HttpClient;
import com.apicatalog.jsonld.http.HttpResponse;
import com.apicatalog.jsonld.http.link.Link;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.DocumentReader;
import com.apicatalog.jsonld.loader.DocumentResolver;
import com.apicatalog.jsonld.uri.UriResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class DefaultHttpLoader
implements DocumentLoader {
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpLoader.class.getName());
    public static final int MAX_REDIRECTIONS = 10;
    private static final String PLUS_JSON = "+json";
    private final int maxRedirections;
    private final HttpClient httpClient;
    private final DocumentResolver resolver;

    public DefaultHttpLoader(HttpClient httpClient) {
        this(httpClient, 10);
    }

    public DefaultHttpLoader(HttpClient httpClient, int maxRedirections) {
        this.httpClient = httpClient;
        this.maxRedirections = maxRedirections;
        this.resolver = new DocumentResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document loadDocument(URI uri, DocumentLoaderOptions options) throws JsonLdError {
        try {
            URI targetUri = uri;
            MediaType contentType = null;
            URI contextUri = null;
            int redirection = 0;
            while (redirection < this.maxRedirections) {
                block21: {
                    try (HttpResponse response = this.httpClient.send(targetUri, DefaultHttpLoader.getAcceptHeader(options.getRequestProfile()));){
                        Collection<String> linkValues;
                        if (response.statusCode() == 301 || response.statusCode() == 302 || response.statusCode() == 303 || response.statusCode() == 307) {
                            Optional<String> location = response.location();
                            if (!location.isPresent()) throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Header location is required for code [" + response.statusCode() + "].");
                            targetUri = UriResolver.resolveAsUri(targetUri, location.get());
                            break block21;
                        }
                        if (response.statusCode() != 200) {
                            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unexpected response code [" + response.statusCode() + "]");
                        }
                        Optional<String> contentTypeValue = response.contentType();
                        if (contentTypeValue.isPresent()) {
                            contentType = MediaType.of(contentTypeValue.get());
                        }
                        if ((linkValues = response.links()) != null && !linkValues.isEmpty()) {
                            URI baseUri;
                            if (contentType == null || !MediaType.JSON.match(contentType) && !contentType.subtype().toLowerCase().endsWith(PLUS_JSON)) {
                                baseUri = targetUri;
                                Optional<Link> alternate = linkValues.stream().flatMap(l -> Link.of(l, baseUri).stream()).filter(l -> l.relations().contains("alternate") && l.type().isPresent() && MediaType.JSON_LD.match(l.type().get())).findFirst();
                                if (alternate.isPresent()) {
                                    targetUri = alternate.get().target();
                                    break block21;
                                }
                            }
                            if (contentType != null && !MediaType.JSON_LD.match(contentType) && (MediaType.JSON.match(contentType) || contentType.subtype().toLowerCase().endsWith(PLUS_JSON))) {
                                baseUri = targetUri;
                                List contextUris = linkValues.stream().flatMap(l -> Link.of(l, baseUri).stream()).filter(l -> l.relations().contains("http://www.w3.org/ns/json-ld#context")).collect(Collectors.toList());
                                if (contextUris.size() > 1) {
                                    throw new JsonLdError(JsonLdErrorCode.MULTIPLE_CONTEXT_LINK_HEADERS);
                                }
                                if (contextUris.size() == 1) {
                                    contextUri = ((Link)contextUris.get(0)).target();
                                }
                            }
                        }
                        if (contentType == null) {
                            LOGGER.log(Level.WARNING, "GET on URL [{0}] does not return content-type header. Trying application/json.", uri);
                            contentType = MediaType.JSON;
                        }
                        Document document = this.resolve(contentType, targetUri, contextUri, response);
                        return document;
                    }
                }
                ++redirection;
            }
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Too many redirections");
        }
        catch (IOException e2) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e2);
        }
    }

    public static final String getAcceptHeader() {
        return DefaultHttpLoader.getAcceptHeader(null);
    }

    public static final String getAcceptHeader(Collection<String> profiles) {
        StringBuilder builder = new StringBuilder();
        builder.append(MediaType.JSON_LD.toString());
        if (profiles != null && !profiles.isEmpty()) {
            builder.append(";profile=\"");
            builder.append(String.join((CharSequence)" ", profiles));
            builder.append("\"");
        }
        builder.append(',');
        builder.append(MediaType.JSON.toString());
        builder.append(";q=0.9,*/*;q=0.1");
        return builder.toString();
    }

    private final Document resolve(MediaType type, URI targetUri, URI contextUrl, HttpResponse response) throws JsonLdError, IOException {
        DocumentReader<InputStream> reader = this.resolver.getReader(type);
        try (InputStream is = response.body();){
            Document remoteDocument = reader.read(is);
            remoteDocument.setDocumentUrl(targetUri);
            remoteDocument.setContextUrl(contextUrl);
            Document document = remoteDocument;
            return document;
        }
    }

    @Deprecated
    public void setFallbackContentType(MediaType fallbackContentType) {
        this.resolver.setFallbackContentType(fallbackContentType);
    }

    public DefaultHttpLoader fallbackContentType(MediaType fallbackContentType) {
        this.resolver.setFallbackContentType(fallbackContentType);
        return this;
    }

    public DefaultHttpLoader timeount(Duration timeount) {
        this.httpClient.timeout(timeount);
        return this;
    }
}

