/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.impl;

import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.nquads.NQuadsAlphabet;
import java.util.Objects;
import java.util.Optional;

final class ImmutableRdfLiteral
implements RdfLiteral {
    private final String value;
    private final String langTag;
    private final String dataType;

    protected ImmutableRdfLiteral(String value, String langTag, String datatype) {
        this.value = value;
        this.langTag = langTag;
        this.dataType = ImmutableRdfLiteral.datatype(langTag, datatype);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDatatype() {
        return this.dataType;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.langTag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataType, this.langTag, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ImmutableRdfLiteral other = (ImmutableRdfLiteral)obj;
            return Objects.equals(this.dataType, other.dataType) && Objects.equals(this.langTag, other.langTag) && Objects.equals(this.value, other.value);
        }
        if (!(obj instanceof RdfLiteral)) {
            return false;
        }
        RdfLiteral other = (RdfLiteral)obj;
        return Objects.equals(this.dataType, other.getDatatype()) && Objects.equals(this.langTag, other.getLanguage().orElse(null)) && Objects.equals(this.value, other.getValue());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        builder.append(NQuadsAlphabet.escape(this.value));
        builder.append('\"');
        if (this.langTag != null) {
            builder.append('@');
            builder.append(this.langTag);
        } else if (this.dataType != null && !"http://www.w3.org/2001/XMLSchema#string".equals(this.dataType)) {
            builder.append("^^<");
            builder.append(this.dataType);
            builder.append('>');
        }
        return builder.toString();
    }

    private static final String datatype(String langTag, String datatype) {
        if (datatype != null) {
            return datatype;
        }
        return langTag == null ? "http://www.w3.org/2001/XMLSchema#string" : "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    }
}

