/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.assemblers.OntModelAssembler;
import org.apache.jena.assembler.assemblers.ReasonerFactoryAssembler;
import org.apache.jena.assembler.exceptions.ReasonerClashException;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.models.ModelGetter;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.shared.NotFoundException;

public class OntModelSpecAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.OntModelSpec);
        OntModelSpec spec = new OntModelSpec(this.getDefault(root2));
        OntDocumentManager dm = this.getDocumentManager(a, root2);
        ReasonerFactory rf = this.getReasonerFactory(a, root2);
        String lang = this.getLanguage(a, root2);
        ModelGetter source = this.getModelSource(a, root2);
        if (dm != null) {
            spec.setDocumentManager(dm);
        }
        if (rf != null) {
            spec.setReasonerFactory(rf);
        }
        if (lang != null) {
            spec.setLanguage(lang);
        }
        if (source != null) {
            spec.setImportModelGetter(source);
        }
        return spec;
    }

    private ModelGetter getModelSource(Assembler a, Resource root2) {
        Resource source = OntModelSpecAssembler.getUniqueResource(root2, JA.importSource);
        return source == null ? null : (ModelGetter)a.open(source);
    }

    private String getLanguage(Assembler a, Resource root2) {
        Resource lang = OntModelSpecAssembler.getUniqueResource(root2, JA.ontLanguage);
        return lang == null ? null : lang.getURI();
    }

    private ReasonerFactory getReasonerFactory(Assembler a, Resource root2) {
        Resource rf = OntModelSpecAssembler.getUniqueResource(root2, JA.reasonerFactory);
        Resource ru = OntModelSpecAssembler.getUniqueResource(root2, JA.reasonerURL);
        if (ru != null && rf != null) {
            throw new ReasonerClashException(root2);
        }
        if (ru != null) {
            return ReasonerFactoryAssembler.getReasonerFactoryByURL(root2, ru);
        }
        return rf == null ? null : (ReasonerFactory)a.open(rf);
    }

    private OntDocumentManager getDocumentManager(Assembler a, Resource root2) {
        Resource dm = OntModelSpecAssembler.getUniqueResource(root2, JA.documentManager);
        return dm == null ? null : (OntDocumentManager)a.open(dm);
    }

    private OntModelSpec getDefault(Resource root2) {
        OntModelSpec DEFAULT2 = OntModelAssembler.defaultSpec();
        if (root2.isURIResource() && root2.getNameSpace().equals("http://jena.hpl.hp.com/2005/11/Assembler#")) {
            OntModelSpec oms = OntModelSpecAssembler.getOntModelSpecField(root2.getLocalName());
            return oms == null ? DEFAULT2 : oms;
        }
        Resource like = OntModelSpecAssembler.getUniqueResource(root2, JA.likeBuiltinSpec);
        return like == null ? DEFAULT2 : this.getRequiredOntModelSpecField(like.getLocalName());
    }

    private OntModelSpec getRequiredOntModelSpecField(String name) {
        OntModelSpec result = OntModelSpecAssembler.getOntModelSpecField(name);
        if (result == null) {
            throw new NotFoundException(name);
        }
        return result;
    }

    public static OntModelSpec getOntModelSpecField(String name) {
        try {
            Class<OntModelSpec> omc = OntModelSpec.class;
            Field f = omc.getField(name);
            int mods = f.getModifiers();
            if (f.getType() == omc && OntModelSpecAssembler.isConstant(mods)) {
                return (OntModelSpec)f.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static boolean isConstant(int mods) {
        return Modifier.isPublic(mods) && Modifier.isFinal(mods) && Modifier.isStatic(mods);
    }
}

