/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import jakarta.servlet.http.HttpServletRequest;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.ctl.ActionContainerItem;
import org.apache.jena.fuseki.ctl.JsonDescription;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.mgt.FusekiAdmin;
import org.apache.jena.fuseki.mgt.FusekiServerCtl;
import org.apache.jena.fuseki.mgt.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.ValidString;
import org.apache.jena.fuseki.server.Validators;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.system.G;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.vocabulary.RDF;

public class ActionDatasets
extends ActionContainerItem {
    private static Property pServiceName = FusekiVocab.pServiceName;
    private static final String paramDatasetName = "dbName";
    private static final String paramDatasetType = "dbType";
    private static final String tDatabaseTDB = "tdb";
    private static final String tDatabaseTDB2 = "tdb2";
    private static final String tDatabaseMem = "mem";
    private static Map<String, String> dbTypeToTemplate = new HashMap<String, String>();
    private static final String NL = "\n";
    private static final String queryStringLocations = "PREFIX tdb1:   <http://jena.hpl.hp.com/2008/tdb#>\nPREFIX tdb2:   <http://jena.apache.org/2016/tdb#>\nSELECT * {\n   ?x ( tdb2:location | tdb1:location) ?location\n}\n";
    private static final Query queryLocations;

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET datasets", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("D");
        builder.key("datasets");
        JsonDescription.arrayDatasets(builder, action.getDataAccessPointRegistry());
        builder.finishObject("D");
        return builder.build();
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        String item = ActionDatasets.getItemDatasetName(action);
        action.log.info(String.format("[%d] GET dataset %s", action.id, item));
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dsDesc = ActionDatasets.getItemDataAccessPoint(action, item);
        if (dsDesc == null) {
            ServletOps.errorNotFound("Not found: dataset " + item);
        }
        JsonDescription.describe(builder, dsDesc);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        UUID uuid2 = UUID.randomUUID();
        ContentType ct = ActionLib.getContentType(action);
        boolean hasParams = action.getRequestParameterNames().hasMoreElements();
        if (ct == null && !hasParams) {
            ServletOps.errorBadRequest("Bad request - Content-Type or both parameters dbName and dbType required");
        }
        boolean succeeded = false;
        String configFile = null;
        String systemFileCopy = null;
        FusekiServerCtl serverCtl = FusekiServerCtl.get(action.getServletContext());
        DatasetDescriptionMap registry = new DatasetDescriptionMap();
        Object object = serverCtl.getServerlock();
        synchronized (object) {
            block36: {
                block37: {
                    DataAccessPoint dataAccessPoint;
                    String datasetPath;
                    Model model;
                    block33: {
                        String tdbLocation2222;
                        block34: {
                            block35: {
                                try {
                                    String datasetName;
                                    boolean templatedRequest;
                                    Model modelFromRequest;
                                    block32: {
                                        modelFromRequest = ModelFactory.createDefaultModel();
                                        StreamRDF dest = StreamRDFLib.graph(modelFromRequest.getGraph());
                                        templatedRequest = false;
                                        try {
                                            if (hasParams || WebContent.isHtmlForm(ct)) {
                                                ActionDatasets.assemblerFromForm(action, dest);
                                                templatedRequest = true;
                                                break block32;
                                            }
                                            if (WebContent.isMultiPartForm(ct)) {
                                                ServletOps.errorBadRequest("Service configuration from a multipart upload not supported");
                                            } else {
                                                if (!FusekiAdmin.allowConfigFiles()) {
                                                    ServletOps.errorBadRequest("Service configuration from an upload file not supported");
                                                }
                                                ActionDatasets.assemblerFromBody(action, dest);
                                            }
                                        }
                                        catch (RiotException ex) {
                                            ActionLib.consumeBody(action);
                                            action.log.warn(String.format("[%d] Failed to read configuration: %s", action.id, ex.getMessage()));
                                            ServletOps.errorBadRequest("Failed to read configuration");
                                        }
                                    }
                                    model = ModelFactory.createDefaultModel();
                                    model.add(modelFromRequest);
                                    model = AssemblerUtils.prepareForAssembler(model);
                                    Statement stmt = this.findService(model);
                                    if (stmt == null) {
                                        action.log.warn(String.format("[%d] No service name", action.id));
                                        ServletOps.errorBadRequest(String.format("No service name", new Object[0]));
                                    }
                                    Resource subject = stmt.getSubject();
                                    Literal object2 = stmt.getObject().asLiteral();
                                    if (object2.getDatatype() != null && !object2.getDatatype().equals(XSDDatatype.XSDstring)) {
                                        action.log.warn(String.format("[%d] Service name '%s' is not a string", action.id, FmtUtils.stringForRDFNode(object2)));
                                    }
                                    if ((datasetName = object2.getLexicalForm()).isEmpty()) {
                                        action.log.warn(String.format("[%d] Empty dataset name", action.id));
                                        ServletOps.errorBadRequest("Empty dataset name");
                                    }
                                    if (StringUtils.isBlank(datasetName)) {
                                        action.log.warn(String.format("[%d] Whitespace dataset name: '%s'", action.id, datasetName));
                                        ServletOps.errorBadRequest(String.format("Whitespace dataset name: '%s'", datasetName));
                                    }
                                    if (datasetName.contains(" ")) {
                                        action.log.warn(String.format("[%d] Bad dataset name (contains spaces) '%s'", action.id, datasetName));
                                        ServletOps.errorBadRequest(String.format("Bad dataset name (contains spaces) '%s'", datasetName));
                                    }
                                    if (datasetName.equals("/")) {
                                        action.log.warn(String.format("[%d] Bad dataset name '%s'", action.id, datasetName));
                                        ServletOps.errorBadRequest(String.format("Bad dataset name '%s'", datasetName));
                                    }
                                    try {
                                        ValidString validString = Validators.serviceName(datasetName);
                                    }
                                    catch (FusekiConfigException ex) {
                                        action.log.warn(String.format("[%d] Invalid service name: '%s'", action.id, datasetName));
                                        ServletOps.error(400, String.format("Invalid service name: '%s'", datasetName));
                                    }
                                    datasetPath = DataAccessPoint.canonical(datasetName);
                                    if (!this.isValidServiceName(datasetPath)) {
                                        action.log.warn(String.format("[%d] Database service name not acceptable: '%s'", action.id, datasetName));
                                        ServletOps.error(400, String.format("Database service name not acceptable: '%s'", datasetName));
                                    }
                                    if (action.getDataAccessPointRegistry().isRegistered(datasetPath)) {
                                        action.log.warn(String.format("[%d] Name already registered '%s'", action.id, datasetPath));
                                        ServletOps.error(409, String.format("Name already registered '%s'", datasetPath));
                                    }
                                    if (!templatedRequest) {
                                        List<String> tdbLocations = ActionDatasets.tdbLocations(action, model.getGraph());
                                        for (String tdbLocation2222 : tdbLocations) {
                                            if (this.isValidTDBLocation(tdbLocation2222)) continue;
                                            action.log.warn(String.format("[%d] TDB database location not acceptable: '%s'", action.id, tdbLocation2222));
                                            ServletOps.error(400, String.format("TDB database location not acceptable: '%s'", tdbLocation2222));
                                        }
                                    }
                                    systemFileCopy = FusekiServerCtl.dirSystemFileArea.resolve(uuid2.toString()).toString();
                                    RDFWriter.source(model).lang(Lang.TURTLE).output(systemFileCopy);
                                    action.log.info(String.format("[%d] Create database : name = %s", action.id, datasetPath));
                                    List<String> existing = FusekiServerCtl.existingConfigurationFile(datasetPath);
                                    if (!existing.isEmpty()) {
                                        ServletOps.error(409, "Configuration file for '" + datasetPath + "' already exists");
                                    }
                                    configFile = FusekiServerCtl.generateConfigurationFilename(datasetPath);
                                    dataAccessPoint = FusekiConfig.buildDataAccessPoint(subject.getModel().getGraph(), subject.asNode(), registry);
                                    if (dataAccessPoint != null) break block33;
                                    FmtLog.error(action.log, "Failed to build DataAccessPoint: datasetPath = %s; DataAccessPoint name = %s", datasetPath, dataAccessPoint);
                                    ServletOps.errorBadRequest("Failed to build DataAccessPoint");
                                    tdbLocation2222 = null;
                                    if (succeeded) break block34;
                                    if (systemFileCopy == null) break block35;
                                }
                                catch (Throwable throwable) {
                                    if (!succeeded) {
                                        if (systemFileCopy != null) {
                                            FileOps.deleteSilent(systemFileCopy);
                                        }
                                        if (configFile != null) {
                                            FileOps.deleteSilent(configFile);
                                        }
                                    }
                                    throw throwable;
                                }
                                FileOps.deleteSilent(systemFileCopy);
                            }
                            if (configFile != null) {
                                FileOps.deleteSilent(configFile);
                            }
                        }
                        return tdbLocation2222;
                    }
                    dataAccessPoint.getDataService().setEndpointProcessors(action.getOperationRegistry());
                    RDFWriter.source(model).lang(Lang.TURTLE).output(configFile);
                    if (!datasetPath.equals(dataAccessPoint.getName())) {
                        FmtLog.warn(action.log, "Inconsistent names: datasetPath = %s; DataAccessPoint name = %s", datasetPath, dataAccessPoint);
                    }
                    dataAccessPoint.getDataService().goActive();
                    succeeded = true;
                    action.getDataAccessPointRegistry().register(dataAccessPoint);
                    MetricsProvider metricProvider = action.getMetricsProvider();
                    if (metricProvider != null) {
                        action.getMetricsProvider().addDataAccessPointMetrics(dataAccessPoint);
                    }
                    action.setResponseContentType("text/plain");
                    ServletOps.success(action);
                    if (succeeded) break block36;
                    if (systemFileCopy == null) break block37;
                    FileOps.deleteSilent(systemFileCopy);
                }
                if (configFile != null) {
                    FileOps.deleteSilent(configFile);
                }
            }
            return null;
        }
    }

    private boolean isValidServiceName(String datasetPath) {
        int idx = datasetPath.indexOf(47, 1);
        if (idx > 0) {
            return false;
        }
        return !datasetPath.startsWith("/..");
    }

    private boolean isValidTDBLocation(String tdbLocation) {
        List<String> components;
        Location location = Location.create(tdbLocation);
        if (location.isMem()) {
            return true;
        }
        return !tdbLocation.startsWith("..") && !tdbLocation.contains("/..") || !(components = FileOps.pathComponents(tdbLocation)).contains("..");
    }

    private Statement findService(Model model) {
        Statement stmt = ActionDatasets.getOne(model, null, pServiceName, null);
        if (stmt == null) {
            Statement stmt3;
            Statement stmt2 = ActionDatasets.getOne(model, null, RDF.type, FusekiVocab.fusekiService);
            if (stmt2 == null) {
                int count = model.listStatements(null, RDF.type, FusekiVocab.fusekiService).toList().size();
                if (count == 0) {
                    ServletOps.errorBadRequest("No triple rdf:type fuseki:Service found");
                } else {
                    ServletOps.errorBadRequest("Multiple Fuseki service descriptions");
                }
            }
            if ((stmt3 = ActionDatasets.getOne(model, stmt2.getSubject(), pServiceName, null)) == null) {
                StmtIterator sIter = model.listStatements(stmt2.getSubject(), pServiceName, (RDFNode)null);
                if (!sIter.hasNext()) {
                    ServletOps.errorBadRequest("No name given in description of Fuseki service");
                }
                sIter.next();
                if (sIter.hasNext()) {
                    ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
                }
                throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
            }
            stmt = stmt3;
        }
        if (stmt == null) {
            return null;
        }
        if (!stmt.getObject().isLiteral()) {
            ServletOps.errorBadRequest("Found " + FmtUtils.stringForRDFNode(stmt.getObject()) + " : Service names are strings, which are then used to build the external URI");
        }
        return stmt;
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        String s;
        DataService dSrv;
        String name = ActionDatasets.getItemDatasetName(action);
        if (name == null) {
            name = "''";
        }
        action.log.info(String.format("[%d] POST dataset %s", action.id, name));
        DataAccessPoint dap = ActionDatasets.getItemDataAccessPoint(action, name);
        if (dap == null) {
            ServletOps.errorNotFound("Not found: dataset " + name);
        }
        if ((dSrv = dap.getDataService()) == null) {
            dSrv = action.getDataAccessPoint().getDataService();
        }
        if ((s = action.getRequestParameter("state")) == null || s.isEmpty()) {
            ServletOps.errorBadRequest("No state change given");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execDeleteItem(HttpAction action) {
        String name = ActionDatasets.getItemDatasetName(action);
        if (name == null) {
            name = "";
        }
        action.log.info(String.format("[%d] DELETE dataset=%s", action.id, name));
        if (!action.getDataAccessPointRegistry().isRegistered(name)) {
            ServletOps.errorNotFound("No such dataset registered: " + name);
        }
        boolean succeeded = false;
        FusekiServerCtl serverCtl = FusekiServerCtl.get(action.getServletContext());
        Object object = serverCtl.getServerlock();
        synchronized (object) {
            Path pDatabase;
            DataAccessPoint ref = action.getDataAccessPointRegistry().get(name);
            if (ref == null) {
                ServletOps.errorNotFound("No such dataset registered: " + name);
            }
            DataService dataService = ref.getDataService();
            action.getDataAccessPointRegistry().remove(name);
            String filename = name.startsWith("/") ? name.substring(1) : name;
            List<String> configurationFiles = FusekiServerCtl.existingConfigurationFile(filename);
            if (configurationFiles.isEmpty()) {
                action.log.warn(String.format("[%d] Can't delete database configuration - not a managed database", action.id, name));
                succeeded = true;
                ServletOps.success(action);
                return;
            }
            if (configurationFiles.size() > 1) {
                action.log.warn(String.format("[%d] There are %d configuration files, not one.", action.id, configurationFiles.size()));
                ServletOps.errorOccurred(String.format("There are %d configuration files, not one. Delete not performed; manual clean up of the filesystem needed.", configurationFiles.size()));
                return;
            }
            String cfgPathname = configurationFiles.get(0);
            FileOps.deleteSilent(cfgPathname);
            boolean isTDB1 = TDBInternal.isTDB1(dataService.getDataset());
            boolean isTDB2 = org.apache.jena.tdb2.sys.TDBInternal.isTDB2(dataService.getDataset());
            try {
                dataService.shutdown();
            }
            catch (JenaException ex) {
                return;
            }
            if ((isTDB1 || isTDB2) && Files.exists(pDatabase = FusekiServerCtl.dirDatabases.resolve(filename), new LinkOption[0])) {
                try {
                    if (Files.isSymbolicLink(pDatabase)) {
                        action.log.info(String.format("[%d] Database is a symbolic link, not removing files", action.id, pDatabase));
                    } else {
                        IO.deleteAll(pDatabase);
                        action.log.info(String.format("[%d] Deleted database files %s", action.id, pDatabase));
                    }
                }
                catch (RuntimeIOException ex) {
                    action.log.error(String.format("[%d] Error while deleting database files %s: %s", action.id, pDatabase, ex.getMessage()), ex);
                }
            }
            succeeded = true;
            ServletOps.success(action);
        }
    }

    private static void assemblerFromBody(HttpAction action, StreamRDF dest) {
        ActionDatasets.bodyAsGraph(action, dest);
    }

    private static void assemblerFromForm(HttpAction action, StreamRDF dest) {
        String dbType = action.getRequestParameter(paramDatasetType);
        String dbName = action.getRequestParameter(paramDatasetName);
        if (StringUtils.isBlank(dbType) || StringUtils.isBlank(dbName)) {
            action.log.warn(String.format("[%d] Both parameters 'dbName' and 'dbType' required and not be blank", action.id));
            ServletOps.errorBadRequest("Received HTML form. Both parameters 'dbName' and 'dbType' required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NAME", dbName);
        FusekiServerCtl serverCtl = FusekiServerCtl.get(action.getServletContext());
        if (serverCtl != null) {
            serverCtl.addGlobals(params);
        } else {
            ServletOps.errorOccurred("No admin area");
        }
        String template = dbTypeToTemplate.get(dbType.toLowerCase(Locale.ROOT));
        if (template == null) {
            ArrayList<String> keys = new ArrayList<String>(dbTypeToTemplate.keySet());
            Collections.sort(keys);
            ServletOps.errorBadRequest(String.format("dbType can be only one of %s", keys));
        }
        String instance = TemplateFunctions.templateFile(serverCtl.getFusekiBase(), template, params, Lang.TTL);
        RDFParser.create().source(new StringReader(instance)).base("http://base/").lang(Lang.TTL).parse(dest);
    }

    private static void assemblerFromUpload(HttpAction action, StreamRDF dest) {
        throw new NotImplemented();
    }

    private static Quad getOne(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = dsg.findNG(g, s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Quad q = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return q;
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static void bodyAsGraph(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.getRequest();
        String base = ActionLib.wholeRequestURL(request);
        ContentType ct = FusekiNetLib.getContentType(request);
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + String.valueOf(ct));
            return;
        }
        dest.prefix("root", base + "#");
        ActionLib.parse(action, dest, lang, base);
    }

    private static List<String> tdbLocations(HttpAction action, Graph configGraph) {
        QueryExec exec = QueryExec.graph(configGraph).query(queryLocations).build();
        try {
            RowSet results = exec.select();
            ArrayList<String> locations = new ArrayList<String>();
            results.forEach(b -> {
                String location;
                Node loc = b.get("location");
                if (loc.isURI()) {
                    location = loc.getURI();
                } else if (Util.isSimpleString(loc)) {
                    location = G.asString(loc);
                } else {
                    ServletOps.errorBadRequest("TDB database location is not a string");
                    location = null;
                }
                locations.add(location);
            });
            ArrayList<String> arrayList = locations;
            if (exec != null) {
                exec.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (exec != null) {
                    try {
                        exec.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ex) {
                ServletOps.errorBadRequest("TDB database location can not be deterined");
                return null;
            }
        }
    }

    static {
        dbTypeToTemplate.put(tDatabaseTDB, "templates/config-tdb");
        dbTypeToTemplate.put(tDatabaseTDB2, "templates/config-tdb2");
        dbTypeToTemplate.put(tDatabaseMem, "templates/config-mem");
        queryLocations = QueryFactory.create(queryStringLocations);
    }
}

