/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.admin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.ArgModuleGeneral;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.ServerArgs;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.mgt.ActionBackup;
import org.apache.jena.fuseki.mgt.ActionBackupList;
import org.apache.jena.fuseki.mgt.ActionDatasets;
import org.apache.jena.fuseki.mgt.FusekiServerCtl;
import org.apache.jena.fuseki.mod.admin.ActionServerStatus;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;

public class FMod_Admin
implements FusekiModule {
    private static Logger LOG = Fuseki.configLog;
    private static ArgDecl argAdmin = new ArgDecl(true, "admin");
    private static ArgDecl argAdminArea = new ArgDecl(true, "adminArea", "adminBase");
    private String admin = null;
    private Path directory = null;

    @Override
    public String name() {
        return "FMod Admin";
    }

    public static FMod_Admin create() {
        return new FMod_Admin();
    }

    @Override
    public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        fusekiCmd.getUsage().startCategory("Admin");
        ArgModuleGeneral argModule = new ArgModuleGeneral(){

            @Override
            public void registerWith(CmdGeneral cmdLine) {
            }

            @Override
            public void processArgs(CmdArgModule cmdLine) {
            }
        };
        argModule.registerWith(fusekiCmd);
    }

    @Override
    public void serverArgsPrepare(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        String dirStr = fusekiCmd.getValue(argAdminArea);
        if (dirStr != null) {
            this.directory = Path.of(dirStr, new String[0]);
        }
        if (this.directory != null) {
            if (!Files.isDirectory(this.directory, new LinkOption[0])) {
                throw new FusekiConfigException("Not a directory: " + dirStr);
            }
            if (!Files.isWritable(this.directory)) {
                throw new FusekiConfigException("Not writable: " + dirStr);
            }
        }
    }

    @Override
    public void prepare(FusekiServer.Builder builder, Set<String> datasetNames, Model configModel) {
        FusekiServerCtl serverCtl = new FusekiServerCtl(this.directory);
        serverCtl.setup();
        Path fusekiBase = serverCtl.getFusekiBase();
        builder.addServletAttribute("org.apache.jena.fuseki:ServerCtl", serverCtl);
        Path shiroIni = fusekiBase.resolve("shiro.ini");
        if (Files.exists(shiroIni, new LinkOption[0])) {
            System.setProperty("FUSEKI_SHIRO", shiroIni.toString());
        } else {
            FmtLog.info(LOG, "No shiro.ini: dir=%s", fusekiBase);
        }
        String configDir = FusekiServerCtl.dirConfiguration.toString();
        List<DataAccessPoint> directoryDatabases = FusekiConfig.readConfigurationDirectory(configDir);
        if (directoryDatabases.isEmpty() && datasetNames.isEmpty()) {
            FmtLog.info(LOG, "No databases: dir=%s", configDir);
        } else {
            datasetNames.forEach(n -> FmtLog.info(Fuseki.configLog, "Database: %s", n));
            directoryDatabases.forEach(dap -> FmtLog.info(Fuseki.configLog, "Database: %s", dap.getName()));
        }
        directoryDatabases.forEach(db -> {
            String dbName = db.getName();
            if (datasetNames.contains(dbName)) {
                FmtLog.warn(LOG, "Database '%s' already added to the Fuseki server builder", dbName);
            }
            builder.add(dbName, db.getDataService());
        });
        ActionBackup actionBackup = new ActionBackup();
        builder.addServlet("/$/datasets/*", new ActionDatasets()).addServlet("/$/server", new ActionServerStatus()).addServlet("/$/backup/*", actionBackup).addServlet("/$/backups/*", actionBackup).addServlet("/$/backups-list", new ActionBackupList()).enableTasks(true).enableStats(true).enablePing(true).enableCompact(true);
    }

    @Override
    public void serverReload(FusekiServer server) {
    }
}

