/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.parsers.wkt;

import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.jts.CoordinateSequenceDimensions;
import org.apache.jena.geosparql.implementation.jts.CustomCoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class WKTWriter {
    public static final String write(GeometryWrapper geometryWrapper) {
        StringBuilder sb = new StringBuilder();
        SRSInfo srsInfo = geometryWrapper.getSrsInfo();
        if (!srsInfo.isWktDefault().booleanValue()) {
            sb.append("<").append(geometryWrapper.getSrsURI()).append("> ");
        }
        Geometry geometry = geometryWrapper.getParsingGeometry();
        CoordinateSequenceDimensions dimensions = geometryWrapper.getCoordinateSequenceDimensions();
        String wktText = WKTWriter.expand(geometry, dimensions);
        sb.append(wktText);
        return sb.toString();
    }

    private static String expand(Geometry geometry, CoordinateSequenceDimensions dimensions) {
        String wktString = "";
        String dimensionString = CoordinateSequenceDimensions.convertDimensions(dimensions);
        switch (geometry.getGeometryType()) {
            case "Point": {
                Point point = (Point)geometry;
                wktString = WKTWriter.buildWKT("POINT", point.getCoordinateSequence(), dimensionString);
                break;
            }
            case "LineString": 
            case "LinearRing": {
                LineString lineString = (LineString)geometry;
                wktString = WKTWriter.buildWKT("LINESTRING", lineString.getCoordinateSequence(), dimensionString);
                break;
            }
            case "Polygon": {
                Polygon polygon = (Polygon)geometry;
                wktString = WKTWriter.buildPolygon(polygon, true, dimensionString);
                break;
            }
            case "MultiPoint": {
                MultiPoint multiPoint = (MultiPoint)geometry;
                wktString = WKTWriter.buildMultiPoint(multiPoint, dimensionString);
                break;
            }
            case "MultiLineString": {
                MultiLineString multiLineString = (MultiLineString)geometry;
                wktString = WKTWriter.buildMultiLineString(multiLineString, dimensionString);
                break;
            }
            case "MultiPolygon": {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                wktString = WKTWriter.buildMultiPolygon(multiPolygon, dimensionString);
                break;
            }
            case "GeometryCollection": {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                wktString = WKTWriter.buildGeometryCollection(geometryCollection, dimensions);
            }
        }
        return wktString;
    }

    private static String convertToWKTText(CustomCoordinateSequence coordSequence) {
        StringBuilder sb = new StringBuilder();
        int size = coordSequence.getSize();
        if (size != 0) {
            sb.append("(");
            String coordText = coordSequence.getCoordinateText(0);
            sb.append(coordText);
            for (int i = 1; i < size; ++i) {
                sb.append(", ");
                coordText = coordSequence.getCoordinateText(i);
                sb.append(coordText);
            }
            sb.append(")");
        } else {
            sb.append(" EMPTY");
        }
        return sb.toString();
    }

    private static String buildWKT(String geometryType, CoordinateSequence coordSeq) {
        return WKTWriter.buildWKT(geometryType, coordSeq, "");
    }

    private static String buildWKT(String geometryType, CoordinateSequence coordSeq, String dimensionString) {
        CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)coordSeq;
        String wktText = WKTWriter.convertToWKTText(coordSequence);
        StringBuilder sb = new StringBuilder(geometryType);
        if (!wktText.equals(" EMPTY")) {
            sb.append(dimensionString);
        }
        sb.append(wktText);
        return sb.toString();
    }

    private static String buildPolygon(Polygon polygon, boolean isIncludeGeometryType, String dimensionString) {
        StringBuilder sb = new StringBuilder();
        if (isIncludeGeometryType) {
            sb.append("POLYGON");
        }
        if (!polygon.isEmpty()) {
            if (isIncludeGeometryType) {
                sb.append(dimensionString);
            }
            sb.append("(");
            LinearRing lineString = polygon.getExteriorRing();
            CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)lineString.getCoordinateSequence();
            sb.append(WKTWriter.convertToWKTText(coordSequence));
            int interiorRings = polygon.getNumInteriorRing();
            for (int i = 0; i < interiorRings; ++i) {
                sb.append(", ");
                LinearRing innerLineString = polygon.getInteriorRingN(i);
                CustomCoordinateSequence innerCoordSequence = (CustomCoordinateSequence)innerLineString.getCoordinateSequence();
                sb.append(WKTWriter.convertToWKTText(innerCoordSequence));
            }
            sb.append(")");
        } else {
            sb.append(" EMPTY");
        }
        return sb.toString();
    }

    private static String buildMultiPoint(MultiPoint multiPoint, String dimensionString) {
        StringBuilder sb = new StringBuilder("MULTIPOINT");
        if (!multiPoint.isEmpty()) {
            sb.append(dimensionString);
            sb.append("(");
            Point point = (Point)multiPoint.getGeometryN(0);
            CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)point.getCoordinateSequence();
            sb.append(WKTWriter.buildWKT("", coordSequence));
            int geomCount = multiPoint.getNumGeometries();
            for (int i = 1; i < geomCount; ++i) {
                sb.append(", ");
                point = (Point)multiPoint.getGeometryN(i);
                coordSequence = (CustomCoordinateSequence)point.getCoordinateSequence();
                sb.append(WKTWriter.buildWKT("", coordSequence));
            }
            sb.append(")");
        } else {
            sb.append(" EMPTY");
        }
        return sb.toString();
    }

    private static String buildMultiLineString(MultiLineString multiLineString, String dimensionString) {
        StringBuilder sb = new StringBuilder("MULTILINESTRING");
        if (!multiLineString.isEmpty()) {
            sb.append(dimensionString);
            sb.append("(");
            LineString lineString = (LineString)multiLineString.getGeometryN(0);
            CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)lineString.getCoordinateSequence();
            sb.append(WKTWriter.buildWKT("", coordSequence));
            int geomCount = multiLineString.getNumGeometries();
            for (int i = 1; i < geomCount; ++i) {
                sb.append(", ");
                lineString = (LineString)multiLineString.getGeometryN(i);
                coordSequence = (CustomCoordinateSequence)lineString.getCoordinateSequence();
                sb.append(WKTWriter.buildWKT("", coordSequence));
            }
            sb.append(")");
        } else {
            sb.append(" EMPTY");
        }
        return sb.toString();
    }

    private static String buildMultiPolygon(MultiPolygon multiPolygon, String dimensionString) {
        StringBuilder sb = new StringBuilder("MULTIPOLYGON");
        if (!multiPolygon.isEmpty()) {
            sb.append(dimensionString);
            sb.append("(");
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(0);
            sb.append(WKTWriter.buildPolygon(polygon, false, dimensionString));
            int geomCount = multiPolygon.getNumGeometries();
            for (int i = 1; i < geomCount; ++i) {
                sb.append(", ");
                polygon = (Polygon)multiPolygon.getGeometryN(i);
                sb.append(WKTWriter.buildPolygon(polygon, false, dimensionString));
            }
            sb.append(")");
        } else {
            sb.append(" EMPTY");
        }
        return sb.toString();
    }

    private static String buildGeometryCollection(GeometryCollection geometryCollection, CoordinateSequenceDimensions dimensions) {
        StringBuilder sb = new StringBuilder("GEOMETRYCOLLECTION");
        if (!geometryCollection.isEmpty()) {
            String dimensionString = CoordinateSequenceDimensions.convertDimensions(dimensions);
            sb.append(dimensionString);
            Geometry geometry = geometryCollection.getGeometryN(0);
            sb.append("(");
            sb.append(WKTWriter.expand(geometry, dimensions));
            int geomCount = geometryCollection.getNumGeometries();
            for (int i = 1; i < geomCount; ++i) {
                sb.append(", ");
                geometry = geometryCollection.getGeometryN(i);
                sb.append(WKTWriter.expand(geometry, dimensions));
            }
            sb.append(")");
        } else {
            sb.append(" EMPTY");
        }
        return sb.toString();
    }
}

