/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmAssociationSet;
import org.apache.olingo.odata2.api.edm.EdmAssociationSetEnd;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNamedImplProv;

public class EdmEntitySetImplProv
extends EdmNamedImplProv
implements EdmEntitySet,
EdmAnnotatable {
    private EntitySet entitySet;
    private EdmEntityContainer edmEntityContainer;
    private EdmEntityType edmEntityType;
    private EdmAnnotationsImplProv annotations;

    public EdmEntitySetImplProv(EdmImplProv edm, EntitySet entitySet, EdmEntityContainer edmEntityContainer) throws EdmException {
        super(edm, entitySet.getName());
        this.entitySet = entitySet;
        this.edmEntityContainer = edmEntityContainer;
    }

    public EdmEntityType getEntityType() throws EdmException {
        if (this.edmEntityType == null) {
            FullQualifiedName fqName = this.entitySet.getEntityType();
            this.edmEntityType = this.edm.getEntityType(fqName.getNamespace(), fqName.getName());
            if (this.edmEntityType == null) {
                throw new EdmException(EdmException.COMMON);
            }
        }
        return this.edmEntityType;
    }

    public EdmEntitySet getRelatedEntitySet(EdmNavigationProperty navigationProperty) throws EdmException {
        EdmAssociationSet associationSet = this.edmEntityContainer.getAssociationSet(this.edmEntityContainer.getEntitySet(this.entitySet.getName()), navigationProperty);
        EdmAssociationSetEnd toEnd = associationSet.getEnd(navigationProperty.getToRole());
        if (toEnd == null) {
            throw new EdmException(EdmException.COMMON);
        }
        EdmEntitySet targetEntitySet = toEnd.getEntitySet();
        if (targetEntitySet == null) {
            throw new EdmException(EdmException.COMMON);
        }
        return targetEntitySet;
    }

    public EdmEntityContainer getEntityContainer() throws EdmException {
        return this.edmEntityContainer;
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.entitySet.getAnnotationAttributes(), this.entitySet.getAnnotationElements());
        }
        return this.annotations;
    }

    public EdmMapping getMapping() throws EdmException {
        return this.entitySet.getMapping();
    }
}

