/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.console.HelpCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.pending.jdk.JDK22;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.system.Environment;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Locales;
import org.apache.sis.util.internal.shared.X364;
import org.apache.sis.util.resources.Errors;

abstract class CommandRunner {
    static final String TEST = "TEST";
    static final ThreadLocal<CommandRunner> instance = new ThreadLocal();
    protected final String commandName;
    private final EnumSet<Option> validOptions;
    protected final EnumMap<Option, Object> options;
    protected final Locale locale;
    protected final ZoneId timezone;
    protected final Charset encoding;
    protected final boolean colors;
    protected final boolean debug;
    protected final PrintWriter out;
    protected final PrintWriter err;
    final StringBuffer outputBuffer;
    protected final List<Object> files;

    CommandRunner(CommandRunner parent) {
        this.commandName = parent.commandName;
        this.validOptions = parent.validOptions;
        this.options = parent.options;
        this.locale = parent.locale;
        this.timezone = parent.timezone;
        this.encoding = parent.encoding;
        this.colors = parent.colors;
        this.debug = parent.debug;
        this.out = parent.out;
        this.err = parent.err;
        this.outputBuffer = parent.outputBuffer;
        this.files = parent.files;
    }

    protected CommandRunner(int commandIndex, Object[] arguments, EnumSet<Option> validOptions) throws InvalidOptionException {
        Console console;
        boolean explicitEncoding;
        Object s;
        this.commandName = commandIndex >= 0 ? arguments[commandIndex].toString() : null;
        this.validOptions = validOptions;
        this.options = new EnumMap(Option.class);
        this.files = new ArrayList<Object>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            String s2;
            if (i == commandIndex) continue;
            Object arg = arguments[i];
            if (arg instanceof CharSequence && (s2 = arg.toString()).startsWith("--")) {
                String name = s2.substring("--".length());
                Option option = Option.forLabel(name);
                if (!validOptions.contains((Object)option)) {
                    throw new InvalidOptionException(Errors.format((short)181, (Object)name), name);
                }
                Object value = null;
                if (option.hasValue) {
                    if (++i >= arguments.length) {
                        throw new InvalidOptionException(Errors.format((short)110, (Object)name), name);
                    }
                    value = arguments[i];
                }
                if (this.options.containsKey((Object)option)) {
                    throw new InvalidOptionException(Errors.format((short)41, (Object)name), name);
                }
                this.options.put(option, value);
                continue;
            }
            this.files.add(arg);
        }
        Option option = null;
        Object value = null;
        try {
            option = Option.DEBUG;
            this.debug = this.options.containsKey((Object)option);
            option = Option.LOCALE;
            value = s = this.getOptionAsString(option);
            this.locale = s != null ? Locales.parse((String)s) : Locale.getDefault(Locale.Category.DISPLAY);
            option = Option.TIMEZONE;
            value = s = this.getOptionAsString(option);
            this.timezone = s != null ? ZoneId.of((String)s) : null;
            option = Option.ENCODING;
            value = s = this.getOptionAsString(option);
            explicitEncoding = s != null;
            this.encoding = explicitEncoding ? Charset.forName((String)s) : Charset.defaultCharset();
            option = Option.COLORS;
            value = this.options.get((Object)option);
            console = System.console();
            this.colors = value != null ? Option.COLORS.parseBoolean(value) : console != null && JDK22.isTerminal((Console)console) && X364.isAnsiSupported();
        }
        catch (RuntimeException e) {
            String name = option.label();
            throw new InvalidOptionException(Errors.format((short)72, (Object)name, value), name);
        }
        if (TEST.equals(this.commandName)) {
            s = new StringWriter();
            this.outputBuffer = ((StringWriter)s).getBuffer();
            this.err = this.out = new PrintWriter((Writer)s);
        } else {
            this.outputBuffer = null;
            this.err = Environment.writer((Console)console, (PrintStream)System.err);
            this.out = explicitEncoding ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true) : Environment.writer((Console)console, (PrintStream)System.out);
        }
    }

    protected final TimeZone getTimeZone() {
        return this.timezone != null ? TimeZone.getTimeZone(this.timezone) : TimeZone.getDefault();
    }

    final String getOptionAsString(Option key) throws InvalidOptionException {
        Object value = this.options.get((Object)key);
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        throw CommandRunner.invalidOption(key, value, null);
    }

    final Path getOptionAsPath(Option key) throws InvalidOptionException {
        Object value = this.options.get((Object)key);
        if (value == null) {
            return null;
        }
        if (value instanceof Path) {
            return (Path)value;
        }
        InvalidPathException cause = null;
        if (value instanceof CharSequence) {
            try {
                return Path.of(value.toString(), new String[0]);
            }
            catch (InvalidPathException e) {
                cause = e;
            }
        }
        throw CommandRunner.invalidOption(key, value, cause);
    }

    final Object getMandatoryOption(Option option) throws InvalidOptionException {
        Object value = this.options.get((Object)option);
        if (value == null) {
            String name = option.label();
            throw new InvalidOptionException(Errors.format((short)110, (Object)name), name);
        }
        return value;
    }

    final boolean hasContradictoryOptions(Option ... exclusive) {
        int i = 0;
        while (i < exclusive.length) {
            Option o1 = exclusive[i++];
            Option o2 = exclusive[i++];
            if (!this.options.containsKey((Object)o1) || !this.options.containsKey((Object)o2)) continue;
            this.err.println(Errors.format((short)115, (Object)o1.label(), (Object)o2.label()));
            return true;
        }
        return false;
    }

    final boolean hasUnexpectedFileCount(int min, int max) {
        short key;
        int expected;
        int size = this.files.size();
        if (size < min) {
            expected = min;
            key = 156;
        } else if (size > max) {
            expected = max;
            key = 159;
        } else {
            return false;
        }
        this.err.println(Errors.format((short)key, (Object)expected, (Object)size));
        return true;
    }

    final void color(X364 code) {
        CommandRunner.color(this.colors, this.out, code);
    }

    static void color(boolean colors, PrintWriter out, X364 code) {
        if (colors) {
            out.print(code.sequence());
        }
    }

    final boolean useStandardInput() {
        return this.files.isEmpty() && System.console() == null;
    }

    final StorageConnector inputConnector(Object input) throws InvalidOptionException {
        StorageConnector connector = new StorageConnector(input);
        Path p = this.getOptionAsPath(Option.METADATA);
        if (p != null) {
            connector.setOption(DataOptionKey.METADATA_PATH, (Object)p);
        }
        return connector;
    }

    private static InvalidOptionException invalidOption(Option key, Object value, Throwable cause) {
        String name = key.label();
        return new InvalidOptionException(Errors.format((short)72, (Object)name, (Object)value), cause, name);
    }

    final void canNotOpen(int fileIndex, Exception e) {
        this.error(Errors.format((short)14, (Object)this.files.get(fileIndex)), e);
    }

    final void error(String message, Exception e) {
        this.out.flush();
        if (this.debug) {
            e.printStackTrace(this.err);
        } else {
            this.err.println(Exceptions.formatChainedMessages((Locale)this.locale, (String)message, (Throwable)e));
        }
        this.err.flush();
    }

    protected void help(String resourceKey) throws IOException {
        new HelpCommand(this).help(false, new String[]{resourceKey}, this.validOptions);
    }

    public abstract int run() throws Exception;

    protected void flush() {
        this.out.flush();
        this.err.flush();
    }
}

