/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.POINT;

public class MSG
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HWND;
    public static final int MESSAGE;
    public static final int WPARAM;
    public static final int LPARAM;
    public static final int TIME;
    public static final int PT;

    MSG(long address, ByteBuffer container) {
        super(address, container);
    }

    public MSG(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), MSG.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long hwnd() {
        return MSG.nhwnd(this.address());
    }

    public int message() {
        return MSG.nmessage(this.address());
    }

    public long wParam() {
        return MSG.nwParam(this.address());
    }

    public long lParam() {
        return MSG.nlParam(this.address());
    }

    public int time() {
        return MSG.ntime(this.address());
    }

    public POINT pt() {
        return MSG.npt(this.address());
    }

    public MSG hwnd(long value) {
        MSG.nhwnd(this.address(), value);
        return this;
    }

    public MSG message(int value) {
        MSG.nmessage(this.address(), value);
        return this;
    }

    public MSG wParam(long value) {
        MSG.nwParam(this.address(), value);
        return this;
    }

    public MSG lParam(long value) {
        MSG.nlParam(this.address(), value);
        return this;
    }

    public MSG time(int value) {
        MSG.ntime(this.address(), value);
        return this;
    }

    public MSG pt(POINT value) {
        MSG.npt(this.address(), value);
        return this;
    }

    public MSG set(long hwnd, int message, long wParam, long lParam, int time, POINT pt) {
        this.hwnd(hwnd);
        this.message(message);
        this.wParam(wParam);
        this.lParam(lParam);
        this.time(time);
        this.pt(pt);
        return this;
    }

    public MSG nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public MSG set(MSG src) {
        return this.nset(src.address());
    }

    public static MSG malloc() {
        return MSG.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static MSG calloc() {
        return MSG.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static MSG create() {
        return new MSG(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static MSG create(long address) {
        return address == 0L ? null : new MSG(address, null);
    }

    public static Buffer malloc(int capacity) {
        return MSG.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MSG.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static MSG mallocStack() {
        return MSG.mallocStack(MemoryStack.stackGet());
    }

    public static MSG callocStack() {
        return MSG.callocStack(MemoryStack.stackGet());
    }

    public static MSG mallocStack(MemoryStack stack) {
        return MSG.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MSG callocStack(MemoryStack stack) {
        return MSG.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MSG.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MSG.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MSG.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MSG.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhwnd(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HWND);
    }

    public static int nmessage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MESSAGE);
    }

    public static long nwParam(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WPARAM);
    }

    public static long nlParam(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LPARAM);
    }

    public static int ntime(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TIME);
    }

    public static POINT npt(long struct) {
        return POINT.create(struct + (long)PT);
    }

    public static void nhwnd(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HWND, value);
    }

    public static void nmessage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MESSAGE, value);
    }

    public static void nwParam(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WPARAM, value);
    }

    public static void nlParam(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LPARAM, value);
    }

    public static void ntime(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TIME, value);
    }

    public static void npt(long struct, POINT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PT, POINT.SIZEOF);
    }

    static {
        Struct.Layout layout = MSG.__struct(MSG.__member(POINTER_SIZE), MSG.__member(4), MSG.__member(POINTER_SIZE), MSG.__member(POINTER_SIZE), MSG.__member(4), MSG.__member(POINT.SIZEOF, POINT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HWND = layout.offsetof(0);
        MESSAGE = layout.offsetof(1);
        WPARAM = layout.offsetof(2);
        LPARAM = layout.offsetof(3);
        TIME = layout.offsetof(4);
        PT = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<MSG, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected MSG newInstance(long address) {
            return new MSG(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long hwnd() {
            return MSG.nhwnd(this.address());
        }

        public int message() {
            return MSG.nmessage(this.address());
        }

        public long wParam() {
            return MSG.nwParam(this.address());
        }

        public long lParam() {
            return MSG.nlParam(this.address());
        }

        public int time() {
            return MSG.ntime(this.address());
        }

        public POINT pt() {
            return MSG.npt(this.address());
        }

        public Buffer hwnd(long value) {
            MSG.nhwnd(this.address(), value);
            return this;
        }

        public Buffer message(int value) {
            MSG.nmessage(this.address(), value);
            return this;
        }

        public Buffer wParam(long value) {
            MSG.nwParam(this.address(), value);
            return this;
        }

        public Buffer lParam(long value) {
            MSG.nlParam(this.address(), value);
            return this;
        }

        public Buffer time(int value) {
            MSG.ntime(this.address(), value);
            return this;
        }

        public Buffer pt(POINT value) {
            MSG.npt(this.address(), value);
            return this;
        }
    }
}

