/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.xxhash.XXH32Canonical;
import org.lwjgl.util.xxhash.XXH64Canonical;

public class XXHash {
    public static final int XXH_OK = 0;
    public static final int XXH_ERROR = 1;
    public static final int XXH_VERSION_MAJOR = 0;
    public static final int XXH_VERSION_MINOR = 5;
    public static final int XXH_VERSION_RELEASE = 0;
    public static final int XXH_VERSION_NUMBER = 500;

    protected XXHash() {
        throw new UnsupportedOperationException();
    }

    public static native int nXXH32(long var0, long var2, int var4);

    public static int XXH32(ByteBuffer input, int seed) {
        return XXHash.nXXH32(MemoryUtil.memAddress(input), input.remaining(), seed);
    }

    public static native long nXXH64(long var0, long var2, long var4);

    public static long XXH64(ByteBuffer input, long seed) {
        return XXHash.nXXH64(MemoryUtil.memAddress(input), input.remaining(), seed);
    }

    public static native long XXH32_createState();

    public static native int nXXH32_freeState(long var0);

    public static int XXH32_freeState(long statePtr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH32_freeState(statePtr);
    }

    public static native long XXH64_createState();

    public static native int nXXH64_freeState(long var0);

    public static int XXH64_freeState(long statePtr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH64_freeState(statePtr);
    }

    public static native int nXXH32_reset(long var0, int var2);

    public static int XXH32_reset(long statePtr, int seed) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH32_reset(statePtr, seed);
    }

    public static native int nXXH32_update(long var0, long var2, long var4);

    public static int XXH32_update(long statePtr, ByteBuffer input) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH32_update(statePtr, MemoryUtil.memAddress(input), input.remaining());
    }

    public static native int nXXH32_digest(long var0);

    public static int XXH32_digest(long statePtr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH32_digest(statePtr);
    }

    public static native int nXXH64_reset(long var0, long var2);

    public static int XXH64_reset(long statePtr, long seed) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH64_reset(statePtr, seed);
    }

    public static native int nXXH64_update(long var0, long var2, long var4);

    public static int XXH64_update(long statePtr, ByteBuffer input) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH64_update(statePtr, MemoryUtil.memAddress(input), input.remaining());
    }

    public static native long nXXH64_digest(long var0);

    public static long XXH64_digest(long statePtr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(statePtr);
        }
        return XXHash.nXXH64_digest(statePtr);
    }

    public static native void nXXH32_canonicalFromHash(long var0, int var2);

    public static void XXH32_canonicalFromHash(XXH32Canonical dst, int hash) {
        XXHash.nXXH32_canonicalFromHash(dst.address(), hash);
    }

    public static native void nXXH64_canonicalFromHash(long var0, long var2);

    public static void XXH64_canonicalFromHash(XXH64Canonical dst, long hash) {
        XXHash.nXXH64_canonicalFromHash(dst.address(), hash);
    }

    public static native int nXXH32_hashFromCanonical(long var0);

    public static int XXH32_hashFromCanonical(XXH32Canonical src) {
        return XXHash.nXXH32_hashFromCanonical(src.address());
    }

    public static native long nXXH64_hashFromCanonical(long var0);

    public static long XXH64_hashFromCanonical(XXH64Canonical src) {
        return XXHash.nXXH64_hashFromCanonical(src.address());
    }

    static {
        Library.initialize();
        MemoryUtil.getAllocator();
    }
}

