/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandle;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilities;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class VkDevice
extends DispatchableHandle {
    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        super(handle, VkDevice.getDeviceCapabilities(handle, physicalDevice, ci));
    }

    private static VKCapabilities getDeviceCapabilities(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        int apiVersion = physicalDevice.getCapabilities().apiVersion;
        return new VKCapabilities(functionName -> {
            VKCapabilities caps = physicalDevice.getCapabilities();
            long address = VkDevice.GetDeviceProcAddr(caps.vkGetDeviceProcAddr, handle, MemoryUtil.memAddress(functionName));
            if (address == 0L && (address = VkInstance.GetInstanceProcAddr(caps.vkGetInstanceProcAddr, physicalDevice.getInstance().address(), MemoryUtil.memAddress(functionName))) == 0L && (address = VK.getFunctionProvider().getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for VK device function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }, apiVersion, VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()));
    }

    static long GetDeviceProcAddr(long __functionAddress, long handle, long functionName) {
        return JNI.callPPP(__functionAddress, handle, functionName);
    }
}

