/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReference;

public class VkSubpassDescription
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int INPUTATTACHMENTCOUNT;
    public static final int PINPUTATTACHMENTS;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PRESOLVEATTACHMENTS;
    public static final int PDEPTHSTENCILATTACHMENT;
    public static final int PRESERVEATTACHMENTCOUNT;
    public static final int PPRESERVEATTACHMENTS;

    VkSubpassDescription(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassDescription(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassDescription.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int flags() {
        return VkSubpassDescription.nflags(this.address());
    }

    public int pipelineBindPoint() {
        return VkSubpassDescription.npipelineBindPoint(this.address());
    }

    public int inputAttachmentCount() {
        return VkSubpassDescription.ninputAttachmentCount(this.address());
    }

    public VkAttachmentReference.Buffer pInputAttachments() {
        return VkSubpassDescription.npInputAttachments(this.address());
    }

    public int colorAttachmentCount() {
        return VkSubpassDescription.ncolorAttachmentCount(this.address());
    }

    public VkAttachmentReference.Buffer pColorAttachments() {
        return VkSubpassDescription.npColorAttachments(this.address());
    }

    public VkAttachmentReference.Buffer pResolveAttachments() {
        return VkSubpassDescription.npResolveAttachments(this.address());
    }

    public VkAttachmentReference pDepthStencilAttachment() {
        return VkSubpassDescription.npDepthStencilAttachment(this.address());
    }

    public int preserveAttachmentCount() {
        return VkSubpassDescription.npreserveAttachmentCount(this.address());
    }

    public IntBuffer pPreserveAttachments() {
        return VkSubpassDescription.npPreserveAttachments(this.address());
    }

    public VkSubpassDescription flags(int value) {
        VkSubpassDescription.nflags(this.address(), value);
        return this;
    }

    public VkSubpassDescription pipelineBindPoint(int value) {
        VkSubpassDescription.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkSubpassDescription pInputAttachments(VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npInputAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription colorAttachmentCount(int value) {
        VkSubpassDescription.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkSubpassDescription pColorAttachments(VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npColorAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription pResolveAttachments(VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npResolveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription pDepthStencilAttachment(VkAttachmentReference value) {
        VkSubpassDescription.npDepthStencilAttachment(this.address(), value);
        return this;
    }

    public VkSubpassDescription pPreserveAttachments(IntBuffer value) {
        VkSubpassDescription.npPreserveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription set(int flags, int pipelineBindPoint, VkAttachmentReference.Buffer pInputAttachments, int colorAttachmentCount, VkAttachmentReference.Buffer pColorAttachments, VkAttachmentReference.Buffer pResolveAttachments, VkAttachmentReference pDepthStencilAttachment, IntBuffer pPreserveAttachments) {
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pInputAttachments(pInputAttachments);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachments(pColorAttachments);
        this.pResolveAttachments(pResolveAttachments);
        this.pDepthStencilAttachment(pDepthStencilAttachment);
        this.pPreserveAttachments(pPreserveAttachments);
        return this;
    }

    public VkSubpassDescription nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkSubpassDescription set(VkSubpassDescription src) {
        return this.nset(src.address());
    }

    public static VkSubpassDescription malloc() {
        return VkSubpassDescription.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSubpassDescription calloc() {
        return VkSubpassDescription.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSubpassDescription create() {
        return new VkSubpassDescription(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassDescription create(long address) {
        return address == 0L ? null : new VkSubpassDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassDescription.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassDescription.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSubpassDescription mallocStack() {
        return VkSubpassDescription.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription callocStack() {
        return VkSubpassDescription.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription mallocStack(MemoryStack stack) {
        return VkSubpassDescription.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassDescription callocStack(MemoryStack stack) {
        return VkSubpassDescription.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassDescription.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassDescription.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassDescription.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassDescription.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINEBINDPOINT);
    }

    public static int ninputAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUTATTACHMENTCOUNT);
    }

    public static VkAttachmentReference.Buffer npInputAttachments(long struct) {
        return VkAttachmentReference.create(MemoryUtil.memGetAddress(struct + (long)PINPUTATTACHMENTS), VkSubpassDescription.ninputAttachmentCount(struct));
    }

    public static int ncolorAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORATTACHMENTCOUNT);
    }

    public static VkAttachmentReference.Buffer npColorAttachments(long struct) {
        return VkAttachmentReference.create(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS), VkSubpassDescription.ncolorAttachmentCount(struct));
    }

    public static VkAttachmentReference.Buffer npResolveAttachments(long struct) {
        return VkAttachmentReference.create(MemoryUtil.memGetAddress(struct + (long)PRESOLVEATTACHMENTS), VkSubpassDescription.ncolorAttachmentCount(struct));
    }

    public static VkAttachmentReference npDepthStencilAttachment(long struct) {
        return VkAttachmentReference.create(MemoryUtil.memGetAddress(struct + (long)PDEPTHSTENCILATTACHMENT));
    }

    public static int npreserveAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRESERVEATTACHMENTCOUNT);
    }

    public static IntBuffer npPreserveAttachments(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PPRESERVEATTACHMENTS), VkSubpassDescription.npreserveAttachmentCount(struct));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void ninputAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INPUTATTACHMENTCOUNT, value);
    }

    public static void npInputAttachments(long struct, VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINPUTATTACHMENTS, VkSubpassDescription.addressSafe(value));
        VkSubpassDescription.ninputAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTS, VkSubpassDescription.addressSafe(value));
    }

    public static void npResolveAttachments(long struct, VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESOLVEATTACHMENTS, VkSubpassDescription.addressSafe(value));
    }

    public static void npDepthStencilAttachment(long struct, VkAttachmentReference value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHSTENCILATTACHMENT, VkSubpassDescription.addressSafe(value));
    }

    public static void npreserveAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRESERVEATTACHMENTCOUNT, value);
    }

    public static void npPreserveAttachments(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPRESERVEATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkSubpassDescription.npreserveAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubpassDescription.ninputAttachmentCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PINPUTATTACHMENTS));
        }
        if (VkSubpassDescription.ncolorAttachmentCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS));
        }
        if (VkSubpassDescription.npreserveAttachmentCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PPRESERVEATTACHMENTS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubpassDescription.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSubpassDescription.__struct(VkSubpassDescription.__member(4), VkSubpassDescription.__member(4), VkSubpassDescription.__member(4), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(4), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(4), VkSubpassDescription.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PIPELINEBINDPOINT = layout.offsetof(1);
        INPUTATTACHMENTCOUNT = layout.offsetof(2);
        PINPUTATTACHMENTS = layout.offsetof(3);
        COLORATTACHMENTCOUNT = layout.offsetof(4);
        PCOLORATTACHMENTS = layout.offsetof(5);
        PRESOLVEATTACHMENTS = layout.offsetof(6);
        PDEPTHSTENCILATTACHMENT = layout.offsetof(7);
        PRESERVEATTACHMENTCOUNT = layout.offsetof(8);
        PPRESERVEATTACHMENTS = layout.offsetof(9);
    }

    public static final class Buffer
    extends StructBuffer<VkSubpassDescription, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassDescription newInstance(long address) {
            return new VkSubpassDescription(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int flags() {
            return VkSubpassDescription.nflags(this.address());
        }

        public int pipelineBindPoint() {
            return VkSubpassDescription.npipelineBindPoint(this.address());
        }

        public int inputAttachmentCount() {
            return VkSubpassDescription.ninputAttachmentCount(this.address());
        }

        public VkAttachmentReference.Buffer pInputAttachments() {
            return VkSubpassDescription.npInputAttachments(this.address());
        }

        public int colorAttachmentCount() {
            return VkSubpassDescription.ncolorAttachmentCount(this.address());
        }

        public VkAttachmentReference.Buffer pColorAttachments() {
            return VkSubpassDescription.npColorAttachments(this.address());
        }

        public VkAttachmentReference.Buffer pResolveAttachments() {
            return VkSubpassDescription.npResolveAttachments(this.address());
        }

        public VkAttachmentReference pDepthStencilAttachment() {
            return VkSubpassDescription.npDepthStencilAttachment(this.address());
        }

        public int preserveAttachmentCount() {
            return VkSubpassDescription.npreserveAttachmentCount(this.address());
        }

        public IntBuffer pPreserveAttachments() {
            return VkSubpassDescription.npPreserveAttachments(this.address());
        }

        public Buffer flags(int value) {
            VkSubpassDescription.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(int value) {
            VkSubpassDescription.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pInputAttachments(VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npInputAttachments(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(int value) {
            VkSubpassDescription.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pResolveAttachments(VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npResolveAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilAttachment(VkAttachmentReference value) {
            VkSubpassDescription.npDepthStencilAttachment(this.address(), value);
            return this;
        }

        public Buffer pPreserveAttachments(IntBuffer value) {
            VkSubpassDescription.npPreserveAttachments(this.address(), value);
            return this;
        }
    }
}

