/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EGL10 {
    public static final int EGL_ALPHA_SIZE = 12321;
    public static final int EGL_BAD_ACCESS = 12290;
    public static final int EGL_BAD_ALLOC = 12291;
    public static final int EGL_BAD_ATTRIBUTE = 12292;
    public static final int EGL_BAD_CONFIG = 12293;
    public static final int EGL_BAD_CONTEXT = 12294;
    public static final int EGL_BAD_CURRENT_SURFACE = 12295;
    public static final int EGL_BAD_DISPLAY = 12296;
    public static final int EGL_BAD_MATCH = 12297;
    public static final int EGL_BAD_NATIVE_PIXMAP = 12298;
    public static final int EGL_BAD_NATIVE_WINDOW = 12299;
    public static final int EGL_BAD_PARAMETER = 12300;
    public static final int EGL_BAD_SURFACE = 12301;
    public static final int EGL_BLUE_SIZE = 12322;
    public static final int EGL_BUFFER_SIZE = 12320;
    public static final int EGL_CONFIG_CAVEAT = 12327;
    public static final int EGL_CONFIG_ID = 12328;
    public static final int EGL_CORE_NATIVE_ENGINE = 12379;
    public static final int EGL_DEPTH_SIZE = 12325;
    public static final int EGL_DONT_CARE = -1;
    public static final int EGL_DRAW = 12377;
    public static final int EGL_EXTENSIONS = 12373;
    public static final int EGL_FALSE = 0;
    public static final int EGL_GREEN_SIZE = 12323;
    public static final int EGL_HEIGHT = 12374;
    public static final int EGL_LARGEST_PBUFFER = 12376;
    public static final int EGL_LEVEL = 12329;
    public static final int EGL_MAX_PBUFFER_HEIGHT = 12330;
    public static final int EGL_MAX_PBUFFER_PIXELS = 12331;
    public static final int EGL_MAX_PBUFFER_WIDTH = 12332;
    public static final int EGL_NATIVE_RENDERABLE = 12333;
    public static final int EGL_NATIVE_VISUAL_ID = 12334;
    public static final int EGL_NATIVE_VISUAL_TYPE = 12335;
    public static final int EGL_NONE = 12344;
    public static final int EGL_NON_CONFORMANT_CONFIG = 12369;
    public static final int EGL_NOT_INITIALIZED = 12289;
    public static final int EGL_PBUFFER_BIT = 1;
    public static final int EGL_PIXMAP_BIT = 2;
    public static final int EGL_READ = 12378;
    public static final int EGL_RED_SIZE = 12324;
    public static final int EGL_SAMPLES = 12337;
    public static final int EGL_SAMPLE_BUFFERS = 12338;
    public static final int EGL_SLOW_CONFIG = 12368;
    public static final int EGL_STENCIL_SIZE = 12326;
    public static final int EGL_SUCCESS = 12288;
    public static final int EGL_SURFACE_TYPE = 12339;
    public static final int EGL_TRANSPARENT_BLUE_VALUE = 12341;
    public static final int EGL_TRANSPARENT_GREEN_VALUE = 12342;
    public static final int EGL_TRANSPARENT_RED_VALUE = 12343;
    public static final int EGL_TRANSPARENT_RGB = 12370;
    public static final int EGL_TRANSPARENT_TYPE = 12340;
    public static final int EGL_TRUE = 1;
    public static final int EGL_VENDOR = 12371;
    public static final int EGL_VERSION = 12372;
    public static final int EGL_WIDTH = 12375;
    public static final int EGL_WINDOW_BIT = 4;
    public static final long EGL_NO_CONTEXT = 0L;
    public static final long EGL_NO_DISPLAY = 0L;
    public static final long EGL_NO_SURFACE = 0L;

    protected EGL10() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglChooseConfig, caps.eglCopyBuffers, caps.eglCreateContext, caps.eglCreatePbufferSurface, caps.eglCreatePixmapSurface, caps.eglCreateWindowSurface, caps.eglDestroyContext, caps.eglDestroySurface, caps.eglGetConfigAttrib, caps.eglGetConfigs, caps.eglGetCurrentDisplay, caps.eglGetCurrentSurface, caps.eglGetDisplay, caps.eglGetError, caps.eglGetProcAddress, caps.eglInitialize, caps.eglMakeCurrent, caps.eglQueryContext, caps.eglQueryString, caps.eglQuerySurface, caps.eglSwapBuffers, caps.eglTerminate, caps.eglWaitGL, caps.eglWaitNative);
    }

    public static int neglChooseConfig(long dpy, long attrib_list, long configs, int config_size, long num_config) {
        long __functionAddress = EGL.getCapabilities().eglChooseConfig;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPPI(__functionAddress, dpy, attrib_list, configs, config_size, num_config);
    }

    public static int eglChooseConfig(long dpy, IntBuffer attrib_list, PointerBuffer configs, IntBuffer num_config) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
            Checks.checkBuffer((Buffer)num_config, 1);
        }
        return EGL10.neglChooseConfig(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(configs), configs == null ? 0 : configs.remaining(), MemoryUtil.memAddress(num_config));
    }

    public static int eglCopyBuffers(long dpy, long surface, long target) {
        long __functionAddress = EGL.getCapabilities().eglCopyBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
            Checks.checkPointer(target);
        }
        return JNI.callPPPI(__functionAddress, dpy, surface, target);
    }

    public static long neglCreateContext(long dpy, long config, long share_context, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, share_context, attrib_list);
    }

    public static long eglCreateContext(long dpy, long config, long share_context, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreateContext(dpy, config, share_context, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePbufferSurface(long dpy, long config, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
        }
        return JNI.callPPPP(__functionAddress, dpy, config, attrib_list);
    }

    public static long eglCreatePbufferSurface(long dpy, long config, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreatePbufferSurface(dpy, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePixmapSurface(long dpy, long config, long pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(pixmap);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, pixmap, attrib_list);
    }

    public static long eglCreatePixmapSurface(long dpy, long config, long pixmap, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreatePixmapSurface(dpy, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreateWindowSurface(long dpy, long config, long win, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(win);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, win, attrib_list);
    }

    public static long eglCreateWindowSurface(long dpy, long config, long win, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreateWindowSurface(dpy, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int eglDestroyContext(long dpy, long ctx) {
        long __functionAddress = EGL.getCapabilities().eglDestroyContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPI(__functionAddress, dpy, ctx);
    }

    public static int eglDestroySurface(long dpy, long surface) {
        long __functionAddress = EGL.getCapabilities().eglDestroySurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPI(__functionAddress, dpy, surface);
    }

    public static int neglGetConfigAttrib(long dpy, long config, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
        }
        return JNI.callPPPI(__functionAddress, dpy, config, attribute, value);
    }

    public static int eglGetConfigAttrib(long dpy, long config, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return EGL10.neglGetConfigAttrib(dpy, config, attribute, MemoryUtil.memAddress(value));
    }

    public static int neglGetConfigs(long dpy, long configs, int config_size, long num_config) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigs;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPI(__functionAddress, dpy, configs, config_size, num_config);
    }

    public static int eglGetConfigs(long dpy, PointerBuffer configs, IntBuffer num_config) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)num_config, 1);
        }
        return EGL10.neglGetConfigs(dpy, MemoryUtil.memAddressSafe(configs), configs == null ? 0 : configs.remaining(), MemoryUtil.memAddress(num_config));
    }

    public static long eglGetCurrentDisplay() {
        long __functionAddress = EGL.getCapabilities().eglGetCurrentDisplay;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress);
    }

    public static long eglGetCurrentSurface(int readdraw) {
        long __functionAddress = EGL.getCapabilities().eglGetCurrentSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress, readdraw);
    }

    public static long eglGetDisplay(long display_id) {
        long __functionAddress = EGL.getCapabilities().eglGetDisplay;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPP(__functionAddress, display_id);
    }

    public static int eglGetError() {
        long __functionAddress = EGL.getCapabilities().eglGetError;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static long neglGetProcAddress(long procname) {
        long __functionAddress = EGL.getCapabilities().eglGetProcAddress;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPP(__functionAddress, procname);
    }

    public static long eglGetProcAddress(ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(procname);
        }
        return EGL10.neglGetProcAddress(MemoryUtil.memAddress(procname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long eglGetProcAddress(CharSequence procname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer procnameEncoded = stack.ASCII(procname);
            long l = EGL10.neglGetProcAddress(MemoryUtil.memAddress(procnameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int neglInitialize(long dpy, long major, long minor) {
        long __functionAddress = EGL.getCapabilities().eglInitialize;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPI(__functionAddress, dpy, major, minor);
    }

    public static int eglInitialize(long dpy, IntBuffer major, IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)major, 1);
            Checks.checkBuffer((Buffer)minor, 1);
        }
        return EGL10.neglInitialize(dpy, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static int eglMakeCurrent(long dpy, long draw, long read, long ctx) {
        long __functionAddress = EGL.getCapabilities().eglMakeCurrent;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(draw);
            Checks.checkPointer(read);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPPPI(__functionAddress, dpy, draw, read, ctx);
    }

    public static int neglQueryContext(long dpy, long ctx, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPPI(__functionAddress, dpy, ctx, attribute, value);
    }

    public static int eglQueryContext(long dpy, long ctx, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return EGL10.neglQueryContext(dpy, ctx, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglQueryString(long dpy, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryString;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPP(__functionAddress, dpy, name);
    }

    public static String eglQueryString(long dpy, int name) {
        long __result = EGL10.neglQueryString(dpy, name);
        return MemoryUtil.memASCII(__result);
    }

    public static int neglQuerySurface(long dpy, long surface, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQuerySurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPPI(__functionAddress, dpy, surface, attribute, value);
    }

    public static int eglQuerySurface(long dpy, long surface, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return EGL10.neglQuerySurface(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }

    public static int eglSwapBuffers(long dpy, long surface) {
        long __functionAddress = EGL.getCapabilities().eglSwapBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPI(__functionAddress, dpy, surface);
    }

    public static int eglTerminate(long dpy) {
        long __functionAddress = EGL.getCapabilities().eglTerminate;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPI(__functionAddress, dpy);
    }

    public static int eglWaitGL() {
        long __functionAddress = EGL.getCapabilities().eglWaitGL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int eglWaitNative(int engine) {
        long __functionAddress = EGL.getCapabilities().eglWaitNative;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, engine);
    }

    public static int eglChooseConfig(long dpy, int[] attrib_list, PointerBuffer configs, int[] num_config) {
        long __functionAddress = EGL.getCapabilities().eglChooseConfig;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
            Checks.checkBuffer(num_config, 1);
        }
        return JNI.callPPPPI(__functionAddress, dpy, attrib_list, MemoryUtil.memAddressSafe(configs), configs == null ? 0 : configs.remaining(), num_config);
    }

    public static long eglCreateContext(long dpy, long config, long share_context, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, share_context, attrib_list);
    }

    public static long eglCreatePbufferSurface(long dpy, long config, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPP(__functionAddress, dpy, config, attrib_list);
    }

    public static long eglCreatePixmapSurface(long dpy, long config, long pixmap, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(pixmap);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, pixmap, attrib_list);
    }

    public static long eglCreateWindowSurface(long dpy, long config, long win, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(win);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, win, attrib_list);
    }

    public static int eglGetConfigAttrib(long dpy, long config, int attribute, int[] value) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, config, attribute, value);
    }

    public static int eglGetConfigs(long dpy, PointerBuffer configs, int[] num_config) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigs;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkBuffer(num_config, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, MemoryUtil.memAddressSafe(configs), configs == null ? 0 : configs.remaining(), num_config);
    }

    public static int eglInitialize(long dpy, int[] major, int[] minor) {
        long __functionAddress = EGL.getCapabilities().eglInitialize;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkBuffer(major, 1);
            Checks.checkBuffer(minor, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, major, minor);
    }

    public static int eglQueryContext(long dpy, long ctx, int attribute, int[] value) {
        long __functionAddress = EGL.getCapabilities().eglQueryContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, ctx, attribute, value);
    }

    public static int eglQuerySurface(long dpy, long surface, int attribute, int[] value) {
        long __functionAddress = EGL.getCapabilities().eglQuerySurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, surface, attribute, value);
    }
}

