/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EGL15 {
    public static final int EGL_CONTEXT_MAJOR_VERSION = 12440;
    public static final int EGL_CONTEXT_MINOR_VERSION = 12539;
    public static final int EGL_CONTEXT_OPENGL_PROFILE_MASK = 12541;
    public static final int EGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY = 12733;
    public static final int EGL_NO_RESET_NOTIFICATION = 12734;
    public static final int EGL_LOSE_CONTEXT_ON_RESET = 12735;
    public static final int EGL_CONTEXT_OPENGL_CORE_PROFILE_BIT = 1;
    public static final int EGL_CONTEXT_OPENGL_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int EGL_CONTEXT_OPENGL_DEBUG = 12720;
    public static final int EGL_CONTEXT_OPENGL_FORWARD_COMPATIBLE = 12721;
    public static final int EGL_CONTEXT_OPENGL_ROBUST_ACCESS = 12722;
    public static final int EGL_OPENGL_ES3_BIT = 64;
    public static final int EGL_CL_EVENT_HANDLE = 12444;
    public static final int EGL_SYNC_CL_EVENT = 12542;
    public static final int EGL_SYNC_CL_EVENT_COMPLETE = 12543;
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE = 12528;
    public static final int EGL_SYNC_TYPE = 12535;
    public static final int EGL_SYNC_STATUS = 12529;
    public static final int EGL_SYNC_CONDITION = 12536;
    public static final int EGL_SIGNALED = 12530;
    public static final int EGL_UNSIGNALED = 12531;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final int EGL_TIMEOUT_EXPIRED = 12533;
    public static final int EGL_CONDITION_SATISFIED = 12534;
    public static final int EGL_SYNC_FENCE = 12537;
    public static final int EGL_GL_COLORSPACE = 12445;
    public static final int EGL_GL_COLORSPACE_SRGB = 12425;
    public static final int EGL_GL_COLORSPACE_LINEAR = 12426;
    public static final int EGL_GL_RENDERBUFFER = 12473;
    public static final int EGL_GL_TEXTURE_2D = 12465;
    public static final int EGL_GL_TEXTURE_LEVEL = 12476;
    public static final int EGL_GL_TEXTURE_3D = 12466;
    public static final int EGL_GL_TEXTURE_ZOFFSET = 12477;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X = 12467;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 12468;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 12469;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 12470;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 12471;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 12472;
    public static final int EGL_IMAGE_PRESERVED = 12498;
    public static final long EGL_FOREVER = -1L;
    public static final long EGL_NO_SYNC = 0L;
    public static final long EGL_NO_IMAGE = 0L;

    protected EGL15() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateSync, caps.eglDestroySync, caps.eglClientWaitSync, caps.eglGetSyncAttrib, caps.eglCreateImage, caps.eglDestroyImage, caps.eglGetPlatformDisplay, caps.eglCreatePlatformWindowSurface, caps.eglCreatePlatformPixmapSurface, caps.eglWaitSync);
    }

    public static long neglCreateSync(long dpy, int type, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, type, attrib_list);
    }

    public static long eglCreateSync(long dpy, int type, PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344L);
        }
        return EGL15.neglCreateSync(dpy, type, MemoryUtil.memAddress(attrib_list));
    }

    public static int eglDestroySync(long dpy, long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPI(__functionAddress, dpy, sync);
    }

    public static int eglClientWaitSync(long dpy, long sync, int flags, long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPJI(__functionAddress, dpy, sync, flags, timeout);
    }

    public static int neglGetSyncAttrib(long dpy, long sync, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPPI(__functionAddress, dpy, sync, attribute, value);
    }

    public static int eglGetSyncAttrib(long dpy, long sync, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EGL15.neglGetSyncAttrib(dpy, sync, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglCreateImage(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
            Checks.checkPointer(buffer);
        }
        return JNI.callPPPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }

    public static long eglCreateImage(long dpy, long ctx, int target, long buffer, PointerBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344L);
        }
        return EGL15.neglCreateImage(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int eglDestroyImage(long dpy, long image) {
        long __functionAddress = EGL.getCapabilities().eglDestroyImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPI(__functionAddress, dpy, image);
    }

    public static long neglGetPlatformDisplay(int platform, long native_display, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplay;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(native_display);
        }
        return JNI.callPPP(__functionAddress, platform, native_display, attrib_list);
    }

    public static long eglGetPlatformDisplay(int platform, long native_display, PointerBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344L);
        }
        return EGL15.neglGetPlatformDisplay(platform, native_display, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformWindowSurface(long dpy, long config, long native_window, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_window);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_window, attrib_list);
    }

    public static long eglCreatePlatformWindowSurface(long dpy, long config, long native_window, PointerBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344L);
        }
        return EGL15.neglCreatePlatformWindowSurface(dpy, config, native_window, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformPixmapSurface(long dpy, long config, long native_pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurface;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_pixmap);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_pixmap, attrib_list);
    }

    public static long eglCreatePlatformPixmapSurface(long dpy, long config, long native_pixmap, PointerBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344L);
        }
        return EGL15.neglCreatePlatformPixmapSurface(dpy, config, native_pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int eglWaitSync(long dpy, long sync, int flags) {
        long __functionAddress = EGL.getCapabilities().eglWaitSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPI(__functionAddress, dpy, sync, flags);
    }
}

