/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.util.Map;
import org.lwjgl.egl.EGL10;
import org.lwjgl.egl.EGL11;
import org.lwjgl.egl.EXTDeviceQuery;
import org.lwjgl.egl.EXTOutputBase;
import org.lwjgl.egl.KHRStream;
import org.lwjgl.system.APIUtil;

public final class EGLUtil {
    private static final Map<Integer, String> EGL_ERROR_TOKENS = APIUtil.apiClassTokens((field, value) -> field.getName().contains("_BAD_"), null, EGL10.class, EGL11.class, EXTDeviceQuery.class, EXTOutputBase.class, KHRStream.class);

    private EGLUtil() {
    }

    public static String getErrorString(int errorCode) {
        switch (errorCode) {
            case 12288: {
                return "Function succeeded.";
            }
            case 12289: {
                return "EGL is not initialized, or could not be initialized, for the specified display.";
            }
            case 12290: {
                return "EGL cannot access a requested resource.";
            }
            case 12291: {
                return "EGL failed to allocate resources for the requested operation.";
            }
            case 12292: {
                return "An unrecognized attribute or attribute value was passed in an attribute list.";
            }
            case 12294: {
                return "An EGLContext argument does not name a valid EGLContext.";
            }
            case 12293: {
                return "An EGLConfig argument does not name a valid EGLConfig.";
            }
            case 12295: {
                return "The current surface of the calling thread is a window, pbuffer, or pixmap that is no longer valid.";
            }
            case 12296: {
                return "An EGLDisplay argument does not name a valid EGLDisplay.";
            }
            case 12301: {
                return "An EGLSurface argument does not name a valid surface (window, pbuffer, or pixmap) configured for rendering.";
            }
            case 12297: {
                return "Arguments are inconsistent.";
            }
            case 12300: {
                return "One or more argument values are invalid.";
            }
            case 12298: {
                return "An EGLNativePixmapType argument does not refer to a valid native pixmap.";
            }
            case 12299: {
                return "An EGLNativeWindowType argument does not refer to a valid native window.";
            }
            case 12302: {
                return "A power management event has occurred. The application must destroy all contexts and reinitialise client API state and objects to continue rendering.";
            }
            case 12843: {
                return "An EGLDeviceEXT argument does not refer to a valid EGLDeviceEXT.";
            }
            case 12845: {
                return "An EGLOutputLayerEXT argument does not name a valid EGLOutputLayerEXT.";
            }
            case 12846: {
                return "An EGLOutputPortEXT argument does not name a valid EGLOutputPortEXT.";
            }
            case 12828: {
                return "An EGLStreamKHR is in EGL_STREAM_STATE_DISCONNECTED_KHR state.";
            }
            case 12827: {
                return "An EGLStreamKHR argument does not refer to a valid EGLStreamKHR.";
            }
        }
        return APIUtil.apiUnknownToken(errorCode);
    }
}

