/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDeviceQuery {
    public static final int EGL_BAD_DEVICE_EXT = 12843;
    public static final int EGL_DEVICE_EXT = 12844;
    public static final long EGL_NO_DEVICE_EXT = 0L;

    protected EXTDeviceQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryDeviceAttribEXT, caps.eglQueryDeviceStringEXT, caps.eglQueryDisplayAttribEXT);
    }

    public static int neglQueryDeviceAttribEXT(long device, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return JNI.callPPI(__functionAddress, device, attribute, value);
    }

    public static int eglQueryDeviceAttribEXT(long device, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTDeviceQuery.neglQueryDeviceAttribEXT(device, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglQueryDeviceStringEXT(long device, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceStringEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return JNI.callPP(__functionAddress, device, name);
    }

    public static String eglQueryDeviceStringEXT(long device, int name) {
        long __result = EXTDeviceQuery.neglQueryDeviceStringEXT(device, name);
        return MemoryUtil.memASCII(__result);
    }

    public static int neglQueryDisplayAttribEXT(long dpy, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDisplayAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPI(__functionAddress, dpy, attribute, value);
    }

    public static int eglQueryDisplayAttribEXT(long dpy, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTDeviceQuery.neglQueryDisplayAttribEXT(dpy, attribute, MemoryUtil.memAddress(value));
    }
}

