/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.egl.EGLDebugMessageKHRCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRDebug {
    public static final int EGL_OBJECT_THREAD_KHR = 13232;
    public static final int EGL_OBJECT_DISPLAY_KHR = 13233;
    public static final int EGL_OBJECT_CONTEXT_KHR = 13234;
    public static final int EGL_OBJECT_SURFACE_KHR = 13235;
    public static final int EGL_OBJECT_IMAGE_KHR = 13236;
    public static final int EGL_OBJECT_SYNC_KHR = 13237;
    public static final int EGL_OBJECT_STREAM_KHR = 13238;
    public static final int EGL_DEBUG_MSG_CRITICAL_KHR = 13241;
    public static final int EGL_DEBUG_MSG_ERROR_KHR = 13242;
    public static final int EGL_DEBUG_MSG_WARN_KHR = 13243;
    public static final int EGL_DEBUG_MSG_INFO_KHR = 13244;
    public static final int EGL_DEBUG_CALLBACK_KHR = 13240;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglDebugMessageControlKHR, caps.eglQueryDebugKHR, caps.eglLabelObjectKHR);
    }

    public static int neglDebugMessageControlKHR(long callback, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, callback, attrib_list);
    }

    public static int eglDebugMessageControlKHR(EGLDebugMessageKHRCallbackI callback, PointerBuffer attrib_list) {
        return KHRDebug.neglDebugMessageControlKHR(callback.address(), MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int neglQueryDebugKHR(int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDebugKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, attribute, value);
    }

    public static int eglQueryDebugKHR(int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return KHRDebug.neglQueryDebugKHR(attribute, MemoryUtil.memAddress(value));
    }

    public static int eglLabelObjectKHR(long display, int objectType, long object, long label) {
        long __functionAddress = EGL.getCapabilities().eglLabelObjectKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(object);
            Checks.checkPointer(label);
        }
        return JNI.callPPPI(__functionAddress, display, objectType, object, label);
    }
}

