/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRImageBase {
    public static final int EGL_IMAGE_PRESERVED_KHR = 12498;
    public static final long EGL_NO_IMAGE_KHR = 0L;

    protected KHRImageBase() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateImageKHR, caps.eglDestroyImageKHR);
    }

    public static long neglCreateImageKHR(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
            Checks.checkPointer(buffer);
        }
        return JNI.callPPPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRImageBase.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int eglDestroyImageKHR(long dpy, long image) {
        long __functionAddress = EGL.getCapabilities().eglDestroyImageKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPI(__functionAddress, dpy, image);
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
            Checks.checkPointer(buffer);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }
}

