/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVStreamMetadata {
    public static final int EGL_MAX_STREAM_METADATA_BLOCKS_NV = 12880;
    public static final int EGL_MAX_STREAM_METADATA_BLOCK_SIZE_NV = 12881;
    public static final int EGL_MAX_STREAM_METADATA_TOTAL_SIZE_NV = 12882;
    public static final int EGL_PRODUCER_METADATA_NV = 12883;
    public static final int EGL_CONSUMER_METADATA_NV = 12884;
    public static final int EGL_PENDING_METADATA_NV = 13096;
    public static final int EGL_METADATA0_SIZE_NV = 12885;
    public static final int EGL_METADATA1_SIZE_NV = 12886;
    public static final int EGL_METADATA2_SIZE_NV = 12887;
    public static final int EGL_METADATA3_SIZE_NV = 12888;
    public static final int EGL_METADATA0_TYPE_NV = 12889;
    public static final int EGL_METADATA1_TYPE_NV = 12890;
    public static final int EGL_METADATA2_TYPE_NV = 12891;
    public static final int EGL_METADATA3_TYPE_NV = 12892;

    protected NVStreamMetadata() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryDisplayAttribNV, caps.eglSetStreamMetadataNV, caps.eglQueryStreamMetadataNV);
    }

    public static int neglQueryDisplayAttribNV(long dpy, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDisplayAttribNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPI(__functionAddress, dpy, attribute, value);
    }

    public static int eglQueryDisplayAttribNV(long dpy, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return NVStreamMetadata.neglQueryDisplayAttribNV(dpy, attribute, MemoryUtil.memAddress(value));
    }

    public static int neglSetStreamMetadataNV(long dpy, long stream, int n, int offset, int size, long data) {
        long __functionAddress = EGL.getCapabilities().eglSetStreamMetadataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, n, offset, size, data);
    }

    public static int eglSetStreamMetadataNV(long dpy, long stream, int n, int offset, ByteBuffer data) {
        return NVStreamMetadata.neglSetStreamMetadataNV(dpy, stream, n, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static int neglQueryStreamMetadataNV(long dpy, long stream, int name, int n, int offset, int size, long data) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamMetadataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, name, n, offset, size, data);
    }

    public static int eglQueryStreamMetadataNV(long dpy, long stream, int name, int n, int offset, ByteBuffer data) {
        return NVStreamMetadata.neglQueryStreamMetadataNV(dpy, stream, name, n, offset, data.remaining(), MemoryUtil.memAddress(data));
    }
}

