/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.OpenALException;
import org.lwjgl.system.MemoryUtil;

public final class ALUtil {
    private ALUtil() {
    }

    public static void checkALCError(long device) {
        int err = ALC10.alcGetError(device);
        if (err != 0) {
            throw new OpenALException(ALC10.alcGetString(device, err));
        }
    }

    public static void checkALError() {
        int err = AL10.alGetError();
        if (err != 0) {
            throw new OpenALException(AL10.alGetString(err));
        }
    }

    public static List<String> getStringList(long deviceHandle, int token) {
        long __result = ALC10.nalcGetString(deviceHandle, token);
        if (__result == 0L) {
            return null;
        }
        ByteBuffer buffer = MemoryUtil.memByteBuffer(__result, Integer.MAX_VALUE);
        ArrayList<String> strings = new ArrayList<String>();
        int offset = 0;
        while (true) {
            if (buffer.get() != 0) {
                continue;
            }
            int limit = buffer.position() - 1;
            if (limit == offset) break;
            strings.add(MemoryUtil.memUTF8(buffer, limit - offset, offset));
            offset = buffer.position();
        }
        return strings;
    }
}

