/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLUtil;
import org.lwjgl.opencl.OpenCLException;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class CL {
    private static FunctionProviderLocal functionProvider;
    private static CLCapabilities icd;

    private CL() {
    }

    public static void create() {
        SharedLibrary CL2;
        switch (Platform.get()) {
            case LINUX: 
            case WINDOWS: {
                CL2 = Library.loadNative(Configuration.OPENCL_LIBRARY_NAME, "OpenCL");
                break;
            }
            case MACOSX: {
                CL2 = Library.loadNative(Configuration.OPENCL_LIBRARY_NAME, "OpenCL", "/System/Library/Frameworks/OpenCL.framework");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        CL.create(CL2);
    }

    public static void create(String libName) {
        CL.create(Library.loadNative(libName));
    }

    private static void create(SharedLibrary OPENCL) {
        try {
            CL.create(new SharedLibraryCL(OPENCL));
        }
        catch (RuntimeException e) {
            OPENCL.free();
            throw e;
        }
    }

    public static void create(FunctionProviderLocal functionProvider) {
        if (CL.functionProvider != null) {
            throw new IllegalStateException("OpenCL has already been created.");
        }
        CL.functionProvider = functionProvider;
        icd = new CLCapabilities(functionProvider, Collections.emptySet());
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
        icd = null;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return functionProvider;
    }

    public static CLCapabilities getICD() {
        return icd;
    }

    public static CLCapabilities createPlatformCapabilities(long cl_platform_id) {
        long[] devices;
        int num_devices;
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        CL.addExtensions(CLUtil.getPlatformInfoStringASCII(cl_platform_id, 2308), supportedExtensions);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pi = stack.mallocInt(1);
            int errcode = CL10.nclGetDeviceIDs(cl_platform_id, -1L, 0, 0L, MemoryUtil.memAddress(pi));
            if (Checks.DEBUG && errcode != 0) {
                throw new OpenCLException("Failed to query number of OpenCL platform devices.");
            }
            num_devices = pi.get(0);
            if (num_devices == 0) {
                CLCapabilities cLCapabilities = null;
                return cLCapabilities;
            }
            PointerBuffer pp = stack.mallocPointer(num_devices);
            errcode = CL10.nclGetDeviceIDs(cl_platform_id, -1L, num_devices, MemoryUtil.memAddress(pp), 0L);
            if (Checks.DEBUG && errcode != 0) {
                throw new OpenCLException("Failed to query OpenCL platform devices.");
            }
            devices = new long[num_devices];
            for (int i = 0; i < num_devices; ++i) {
                devices[i] = pp.get(i);
            }
        }
        for (int i = 0; i < num_devices; ++i) {
            String extensionsString = CLUtil.getDeviceInfoStringASCII(devices[i], 4144);
            CL.addExtensions(extensionsString, supportedExtensions);
        }
        APIUtil.APIVersion version = APIUtil.apiParseVersion(CLUtil.getPlatformInfoStringASCII(cl_platform_id, 2305), "OpenCL");
        CL.addCLVersions(version.major, version.minor, supportedExtensions);
        return new CLCapabilities(functionName -> CL.getFunctionProvider().getFunctionAddress(cl_platform_id, functionName), supportedExtensions);
    }

    public static CLCapabilities createDeviceCapabilities(long cl_device_id, CLCapabilities platformCapabilities) {
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        String extensionsString = CLUtil.getDeviceInfoStringASCII(cl_device_id, 4144);
        CL.addExtensions(extensionsString, supportedExtensions);
        APIUtil.APIVersion version = APIUtil.apiParseVersion(CLUtil.getDeviceInfoStringASCII(cl_device_id, 4143), "OpenCL");
        CL.addCLVersions(version.major, version.minor, supportedExtensions);
        return new CLCapabilities(platformCapabilities, supportedExtensions);
    }

    static void addExtensions(String extensionsString, Set<String> supportedExtensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static void addCLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions) {
        CL.addCLVersions(MAJOR, MINOR, supportedExtensions, "", new int[][]{{0, 1, 2}, {0, 1}});
        if (supportedExtensions.contains("cl_khr_gl_sharing") || supportedExtensions.contains("cl_APPLE_gl_sharing")) {
            CL.addCLVersions(MAJOR, MINOR, supportedExtensions, "GL", new int[][]{{0, 2}, new int[0]});
        }
    }

    private static void addCLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions, String postfix, int[][] versions) {
        block0: for (int major = 1; major <= Math.min(MAJOR, versions.length); ++major) {
            for (int minor : versions[major - 1]) {
                if (major == MAJOR && MINOR < minor) continue block0;
                supportedExtensions.add(String.format("OpenCL%d%d%s", major, minor, postfix));
            }
        }
    }

    static boolean checkExtension(String extension, boolean supported) {
        if (supported) {
            return true;
        }
        APIUtil.apiLog("[CL] " + extension + " was reported as available but an entry point is missing.");
        return false;
    }

    static {
        if (!Configuration.OPENCL_EXPLICIT_INIT.get(false).booleanValue()) {
            CL.create();
        }
    }

    private static class SharedLibraryCL
    extends SharedLibrary.Delegate
    implements FunctionProviderLocal {
        private final long clGetExtensionFunctionAddress;
        private final long clGetExtensionFunctionAddressForPlatform;
        private final long platform;

        SharedLibraryCL(SharedLibrary library) {
            super(library);
            this.clGetExtensionFunctionAddress = library.getFunctionAddress("clGetExtensionFunctionAddress");
            this.clGetExtensionFunctionAddressForPlatform = library.getFunctionAddress("clGetExtensionFunctionAddressForPlatform");
            if (this.clGetExtensionFunctionAddress == 0L && this.clGetExtensionFunctionAddressForPlatform == 0L) {
                throw new OpenCLException("A core OpenCL function is missing. Make sure that OpenCL is available.");
            }
            long platform = 0L;
            if (this.clGetExtensionFunctionAddressForPlatform != 0L) {
                long clGetPlatformIDs = library.getFunctionAddress("clGetPlatformIDs");
                if (clGetPlatformIDs == 0L) {
                    throw new OpenCLException("A core OpenCL function is missing. Make sure that OpenCL is available.");
                }
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer pi = stack.ints(0);
                    JNI.callPPI(clGetPlatformIDs, 0, 0L, MemoryUtil.memAddress(pi));
                    int platforms = pi.get(0);
                    if (platforms == 1) {
                        PointerBuffer pp = stack.pointers(0L);
                        JNI.callPPI(clGetPlatformIDs, 1, MemoryUtil.memAddress(pp), 0L);
                        long cl_platform_id = pp.get(0);
                        if (this.supportsOpenCL12(stack, cl_platform_id)) {
                            platform = cl_platform_id;
                        }
                    } else if (this.clGetExtensionFunctionAddress == 0L) {
                        throw new IllegalStateException();
                    }
                }
            }
            this.platform = platform;
        }

        private boolean supportsOpenCL12(MemoryStack stack, long platform) {
            ByteBuffer version;
            long clGetPlatformInfo = this.library.getFunctionAddress("clGetPlatformInfo");
            if (clGetPlatformInfo == 0L) {
                return false;
            }
            PointerBuffer pp = stack.mallocPointer(1);
            int errcode = JNI.callPPPPI(clGetPlatformInfo, platform, 2305, 0L, 0L, MemoryUtil.memAddress(pp));
            if (errcode != 0) {
                return false;
            }
            int bytes = (int)pp.get(0);
            errcode = JNI.callPPPPI(clGetPlatformInfo, platform, 2305, (long)bytes, MemoryUtil.memAddress(version = stack.malloc(bytes)), 0L);
            if (errcode != 0) {
                return false;
            }
            APIUtil.APIVersion apiVersion = APIUtil.apiParseVersion(MemoryUtil.memASCII(version, bytes - 1), "OpenCL");
            return 1 < apiVersion.major || 2 <= apiVersion.minor;
        }

        @Override
        public long getFunctionAddress(ByteBuffer functionName) {
            long address;
            long nameEncoded = MemoryUtil.memAddress(functionName);
            long l = address = this.platform == 0L ? JNI.callPP(this.clGetExtensionFunctionAddress, nameEncoded) : JNI.callPPP(this.clGetExtensionFunctionAddressForPlatform, this.platform, nameEncoded);
            if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for CL function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }

        @Override
        public long getFunctionAddress(long handle, ByteBuffer functionName) {
            long address = JNI.callPPP(this.clGetExtensionFunctionAddressForPlatform, handle, MemoryUtil.memAddress(functionName));
            return address != 0L ? address : this.getFunctionAddress(functionName);
        }
    }
}

