/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLImageDesc
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE_TYPE;
    public static final int IMAGE_WIDTH;
    public static final int IMAGE_HEIGHT;
    public static final int IMAGE_DEPTH;
    public static final int IMAGE_ARRAY_SIZE;
    public static final int IMAGE_ROW_PITCH;
    public static final int IMAGE_SLICE_PITCH;
    public static final int NUM_MIP_LEVELS;
    public static final int NUM_SAMPLES;
    public static final int BUFFER;

    CLImageDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public CLImageDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CLImageDesc.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int image_type() {
        return CLImageDesc.nimage_type(this.address());
    }

    public long image_width() {
        return CLImageDesc.nimage_width(this.address());
    }

    public long image_height() {
        return CLImageDesc.nimage_height(this.address());
    }

    public long image_depth() {
        return CLImageDesc.nimage_depth(this.address());
    }

    public long image_array_size() {
        return CLImageDesc.nimage_array_size(this.address());
    }

    public long image_row_pitch() {
        return CLImageDesc.nimage_row_pitch(this.address());
    }

    public long image_slice_pitch() {
        return CLImageDesc.nimage_slice_pitch(this.address());
    }

    public int num_mip_levels() {
        return CLImageDesc.nnum_mip_levels(this.address());
    }

    public int num_samples() {
        return CLImageDesc.nnum_samples(this.address());
    }

    public long buffer() {
        return CLImageDesc.nbuffer(this.address());
    }

    public CLImageDesc image_type(int value) {
        CLImageDesc.nimage_type(this.address(), value);
        return this;
    }

    public CLImageDesc image_width(long value) {
        CLImageDesc.nimage_width(this.address(), value);
        return this;
    }

    public CLImageDesc image_height(long value) {
        CLImageDesc.nimage_height(this.address(), value);
        return this;
    }

    public CLImageDesc image_depth(long value) {
        CLImageDesc.nimage_depth(this.address(), value);
        return this;
    }

    public CLImageDesc image_array_size(long value) {
        CLImageDesc.nimage_array_size(this.address(), value);
        return this;
    }

    public CLImageDesc image_row_pitch(long value) {
        CLImageDesc.nimage_row_pitch(this.address(), value);
        return this;
    }

    public CLImageDesc image_slice_pitch(long value) {
        CLImageDesc.nimage_slice_pitch(this.address(), value);
        return this;
    }

    public CLImageDesc num_mip_levels(int value) {
        CLImageDesc.nnum_mip_levels(this.address(), value);
        return this;
    }

    public CLImageDesc num_samples(int value) {
        CLImageDesc.nnum_samples(this.address(), value);
        return this;
    }

    public CLImageDesc buffer(long value) {
        CLImageDesc.nbuffer(this.address(), value);
        return this;
    }

    public CLImageDesc set(int image_type, long image_width, long image_height, long image_depth, long image_array_size, long image_row_pitch, long image_slice_pitch, int num_mip_levels, int num_samples, long buffer) {
        this.image_type(image_type);
        this.image_width(image_width);
        this.image_height(image_height);
        this.image_depth(image_depth);
        this.image_array_size(image_array_size);
        this.image_row_pitch(image_row_pitch);
        this.image_slice_pitch(image_slice_pitch);
        this.num_mip_levels(num_mip_levels);
        this.num_samples(num_samples);
        this.buffer(buffer);
        return this;
    }

    public CLImageDesc nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public CLImageDesc set(CLImageDesc src) {
        return this.nset(src.address());
    }

    public static CLImageDesc malloc() {
        return CLImageDesc.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CLImageDesc calloc() {
        return CLImageDesc.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CLImageDesc create() {
        return new CLImageDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CLImageDesc create(long address) {
        return address == 0L ? null : new CLImageDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CLImageDesc.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLImageDesc.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CLImageDesc mallocStack() {
        return CLImageDesc.mallocStack(MemoryStack.stackGet());
    }

    public static CLImageDesc callocStack() {
        return CLImageDesc.callocStack(MemoryStack.stackGet());
    }

    public static CLImageDesc mallocStack(MemoryStack stack) {
        return CLImageDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLImageDesc callocStack(MemoryStack stack) {
        return CLImageDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLImageDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLImageDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLImageDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLImageDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nimage_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_TYPE);
    }

    public static long nimage_width(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)IMAGE_WIDTH);
    }

    public static long nimage_height(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)IMAGE_HEIGHT);
    }

    public static long nimage_depth(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)IMAGE_DEPTH);
    }

    public static long nimage_array_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)IMAGE_ARRAY_SIZE);
    }

    public static long nimage_row_pitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)IMAGE_ROW_PITCH);
    }

    public static long nimage_slice_pitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)IMAGE_SLICE_PITCH);
    }

    public static int nnum_mip_levels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_MIP_LEVELS);
    }

    public static int nnum_samples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_SAMPLES);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BUFFER);
    }

    public static void nimage_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_TYPE, value);
    }

    public static void nimage_width(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGE_WIDTH, value);
    }

    public static void nimage_height(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGE_HEIGHT, value);
    }

    public static void nimage_depth(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGE_DEPTH, value);
    }

    public static void nimage_array_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGE_ARRAY_SIZE, value);
    }

    public static void nimage_row_pitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGE_ROW_PITCH, value);
    }

    public static void nimage_slice_pitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGE_SLICE_PITCH, value);
    }

    public static void nnum_mip_levels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_MIP_LEVELS, value);
    }

    public static void nnum_samples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_SAMPLES, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = CLImageDesc.__struct(CLImageDesc.__member(4), CLImageDesc.__member(POINTER_SIZE), CLImageDesc.__member(POINTER_SIZE), CLImageDesc.__member(POINTER_SIZE), CLImageDesc.__member(POINTER_SIZE), CLImageDesc.__member(POINTER_SIZE), CLImageDesc.__member(POINTER_SIZE), CLImageDesc.__member(4), CLImageDesc.__member(4), CLImageDesc.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE_TYPE = layout.offsetof(0);
        IMAGE_WIDTH = layout.offsetof(1);
        IMAGE_HEIGHT = layout.offsetof(2);
        IMAGE_DEPTH = layout.offsetof(3);
        IMAGE_ARRAY_SIZE = layout.offsetof(4);
        IMAGE_ROW_PITCH = layout.offsetof(5);
        IMAGE_SLICE_PITCH = layout.offsetof(6);
        NUM_MIP_LEVELS = layout.offsetof(7);
        NUM_SAMPLES = layout.offsetof(8);
        BUFFER = layout.offsetof(9);
    }

    public static final class Buffer
    extends StructBuffer<CLImageDesc, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CLImageDesc newInstance(long address) {
            return new CLImageDesc(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int image_type() {
            return CLImageDesc.nimage_type(this.address());
        }

        public long image_width() {
            return CLImageDesc.nimage_width(this.address());
        }

        public long image_height() {
            return CLImageDesc.nimage_height(this.address());
        }

        public long image_depth() {
            return CLImageDesc.nimage_depth(this.address());
        }

        public long image_array_size() {
            return CLImageDesc.nimage_array_size(this.address());
        }

        public long image_row_pitch() {
            return CLImageDesc.nimage_row_pitch(this.address());
        }

        public long image_slice_pitch() {
            return CLImageDesc.nimage_slice_pitch(this.address());
        }

        public int num_mip_levels() {
            return CLImageDesc.nnum_mip_levels(this.address());
        }

        public int num_samples() {
            return CLImageDesc.nnum_samples(this.address());
        }

        public long buffer() {
            return CLImageDesc.nbuffer(this.address());
        }

        public Buffer image_type(int value) {
            CLImageDesc.nimage_type(this.address(), value);
            return this;
        }

        public Buffer image_width(long value) {
            CLImageDesc.nimage_width(this.address(), value);
            return this;
        }

        public Buffer image_height(long value) {
            CLImageDesc.nimage_height(this.address(), value);
            return this;
        }

        public Buffer image_depth(long value) {
            CLImageDesc.nimage_depth(this.address(), value);
            return this;
        }

        public Buffer image_array_size(long value) {
            CLImageDesc.nimage_array_size(this.address(), value);
            return this;
        }

        public Buffer image_row_pitch(long value) {
            CLImageDesc.nimage_row_pitch(this.address(), value);
            return this;
        }

        public Buffer image_slice_pitch(long value) {
            CLImageDesc.nimage_slice_pitch(this.address(), value);
            return this;
        }

        public Buffer num_mip_levels(int value) {
            CLImageDesc.nnum_mip_levels(this.address(), value);
            return this;
        }

        public Buffer num_samples(int value) {
            CLImageDesc.nnum_samples(this.address(), value);
            return this;
        }

        public Buffer buffer(long value) {
            CLImageDesc.nbuffer(this.address(), value);
            return this;
        }
    }
}

