/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL40 {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_GEOMETRY_SHADER_INVOCATIONS = 34943;
    public static final int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 36442;
    public static final int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 36443;
    public static final int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 36444;
    public static final int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 36445;
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;
    public static final int GL_SAMPLE_SHADING = 35894;
    public static final int GL_MIN_SAMPLE_SHADING_VALUE = 35895;
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;
    public static final int GL_PATCHES = 14;
    public static final int GL_PATCH_VERTICES = 36466;
    public static final int GL_PATCH_DEFAULT_INNER_LEVEL = 36467;
    public static final int GL_PATCH_DEFAULT_OUTER_LEVEL = 36468;
    public static final int GL_TESS_CONTROL_OUTPUT_VERTICES = 36469;
    public static final int GL_TESS_GEN_MODE = 36470;
    public static final int GL_TESS_GEN_SPACING = 36471;
    public static final int GL_TESS_GEN_VERTEX_ORDER = 36472;
    public static final int GL_TESS_GEN_POINT_MODE = 36473;
    public static final int GL_ISOLINES = 36474;
    public static final int GL_FRACTIONAL_ODD = 36475;
    public static final int GL_FRACTIONAL_EVEN = 36476;
    public static final int GL_MAX_PATCH_VERTICES = 36477;
    public static final int GL_MAX_TESS_GEN_LEVEL = 36478;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 36479;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 36480;
    public static final int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 36481;
    public static final int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 36482;
    public static final int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 36483;
    public static final int GL_MAX_TESS_PATCH_COMPONENTS = 36484;
    public static final int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 36485;
    public static final int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 36486;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 36489;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 36490;
    public static final int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 34924;
    public static final int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 34925;
    public static final int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 36382;
    public static final int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 36383;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 34032;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 34033;
    public static final int GL_TESS_EVALUATION_SHADER = 36487;
    public static final int GL_TESS_CONTROL_SHADER = 36488;
    public static final int GL_TEXTURE_CUBE_MAP_ARRAY = 36873;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 36874;
    public static final int GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 36875;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY = 36876;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 36877;
    public static final int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 36878;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 36879;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 36447;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 36464;
    public static final int GL_MAX_VERTEX_STREAMS = 36465;

    protected GL40() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBlendEquationi, caps.glBlendEquationSeparatei, caps.glBlendFunci, caps.glBlendFuncSeparatei, caps.glDrawArraysIndirect, caps.glDrawElementsIndirect, caps.glUniform1d, caps.glUniform2d, caps.glUniform3d, caps.glUniform4d, caps.glUniform1dv, caps.glUniform2dv, caps.glUniform3dv, caps.glUniform4dv, caps.glUniformMatrix2dv, caps.glUniformMatrix3dv, caps.glUniformMatrix4dv, caps.glUniformMatrix2x3dv, caps.glUniformMatrix2x4dv, caps.glUniformMatrix3x2dv, caps.glUniformMatrix3x4dv, caps.glUniformMatrix4x2dv, caps.glUniformMatrix4x3dv, caps.glGetUniformdv, caps.glMinSampleShading, caps.glGetSubroutineUniformLocation, caps.glGetSubroutineIndex, caps.glGetActiveSubroutineUniformiv, caps.glGetActiveSubroutineUniformName, caps.glGetActiveSubroutineName, caps.glUniformSubroutinesuiv, caps.glGetUniformSubroutineuiv, caps.glGetProgramStageiv, caps.glPatchParameteri, caps.glPatchParameterfv, caps.glBindTransformFeedback, caps.glDeleteTransformFeedbacks, caps.glGenTransformFeedbacks, caps.glIsTransformFeedback, caps.glPauseTransformFeedback, caps.glResumeTransformFeedback, caps.glDrawTransformFeedback, caps.glDrawTransformFeedbackStream, caps.glBeginQueryIndexed, caps.glEndQueryIndexed, caps.glGetQueryIndexediv);
    }

    public static void glBlendEquationi(int buf, int mode) {
        long __functionAddress = GL.getCapabilities().glBlendEquationi;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, buf, mode);
    }

    public static void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha) {
        long __functionAddress = GL.getCapabilities().glBlendEquationSeparatei;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, buf, modeRGB, modeAlpha);
    }

    public static void glBlendFunci(int buf, int sfactor, int dfactor) {
        long __functionAddress = GL.getCapabilities().glBlendFunci;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, buf, sfactor, dfactor);
    }

    public static void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        long __functionAddress = GL.getCapabilities().glBlendFuncSeparatei;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public static void nglDrawArraysIndirect(int mode, long indirect) {
        long __functionAddress = GL.getCapabilities().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 16);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirect) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        GL40.nglDrawArraysIndirect(mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 4);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void nglDrawElementsIndirect(int mode, int type, long indirect) {
        long __functionAddress = GL.getCapabilities().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 20);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirect) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        GL40.nglDrawElementsIndirect(mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 5);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glUniform1d(int location, double x) {
        long __functionAddress = GL.getCapabilities().glUniform1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, x);
    }

    public static void glUniform2d(int location, double x, double y) {
        long __functionAddress = GL.getCapabilities().glUniform2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, x, y);
    }

    public static void glUniform3d(int location, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glUniform3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, x, y, z);
    }

    public static void glUniform4d(int location, double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glUniform4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, x, y, z, w);
    }

    public static void nglUniform1dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1dv(int location, DoubleBuffer value) {
        GL40.nglUniform1dv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2dv(int location, DoubleBuffer value) {
        GL40.nglUniform2dv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3dv(int location, DoubleBuffer value) {
        GL40.nglUniform3dv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4dv(int location, DoubleBuffer value) {
        GL40.nglUniform4dv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix2dv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix3dv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix4dv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2x3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x3dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix2x3dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2x4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x4dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix2x4dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x2dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix3x2dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x4dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix3x4dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x2dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix4x2dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x3dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix4x3dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglGetUniformdv(int program, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformdv(int program, int location, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL40.nglGetUniformdv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetUniformd(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            GL40.nglGetUniformdv(program, location, MemoryUtil.memAddress(params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glMinSampleShading(float value) {
        long __functionAddress = GL.getCapabilities().glMinSampleShading;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, value);
    }

    public static int nglGetSubroutineUniformLocation(int program, int shadertype, long name) {
        long __functionAddress = GL.getCapabilities().glGetSubroutineUniformLocation;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineUniformLocation(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL40.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSubroutineUniformLocation(int program, int shadertype, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL40.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetSubroutineIndex(int program, int shadertype, long name) {
        long __functionAddress = GL.getCapabilities().glGetSubroutineIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineIndex(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL40.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSubroutineIndex(int program, int shadertype, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL40.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, long values) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveSubroutineUniformi(int program, int shadertype, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index) {
        int bufsize = GL40.glGetActiveSubroutineUniformi(program, shadertype, index, 35385);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL40.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineName(int program, int shadertype, int index) {
        int bufsize = GL40.glGetProgramStagei(program, shadertype, 36424);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglUniformSubroutinesuiv(int shadertype, int count, long indices) {
        long __functionAddress = GL.getCapabilities().glUniformSubroutinesuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, count, indices);
    }

    public static void glUniformSubroutinesuiv(int shadertype, IntBuffer indices) {
        GL40.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.memAddress(indices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glUniformSubroutinesui(int shadertype, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer indices = stack.ints(index);
            GL40.nglUniformSubroutinesuiv(shadertype, 1, MemoryUtil.memAddress(indices));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformSubroutineuiv(int shadertype, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformSubroutineuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformSubroutineui(int shadertype, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramStageiv(int program, int shadertype, int pname, long values) {
        long __functionAddress = GL.getCapabilities().glGetProgramStageiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, shadertype, pname, values);
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramStagei(int program, int shadertype, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glPatchParameteri(int pname, int value) {
        long __functionAddress = GL.getCapabilities().glPatchParameteri;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, pname, value);
    }

    public static void nglPatchParameterfv(int pname, long values) {
        long __functionAddress = GL.getCapabilities().glPatchParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, values);
    }

    public static void glPatchParameterfv(int pname, FloatBuffer values) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)values, GL11.glGetInteger(36466));
        }
        GL40.nglPatchParameterfv(pname, MemoryUtil.memAddress(values));
    }

    public static void glBindTransformFeedback(int target, int id) {
        long __functionAddress = GL.getCapabilities().glBindTransformFeedback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, id);
    }

    public static void nglDeleteTransformFeedbacks(int n, long ids) {
        long __functionAddress = GL.getCapabilities().glDeleteTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, ids);
    }

    public static void glDeleteTransformFeedbacks(IntBuffer ids) {
        GL40.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTransformFeedbacks(int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GL40.nglDeleteTransformFeedbacks(1, MemoryUtil.memAddress(ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenTransformFeedbacks(int n, long ids) {
        long __functionAddress = GL.getCapabilities().glGenTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, ids);
    }

    public static void glGenTransformFeedbacks(IntBuffer ids) {
        GL40.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenTransformFeedbacks() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GL40.nglGenTransformFeedbacks(1, MemoryUtil.memAddress(ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsTransformFeedback(int id) {
        long __functionAddress = GL.getCapabilities().glIsTransformFeedback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, id);
    }

    public static void glPauseTransformFeedback() {
        long __functionAddress = GL.getCapabilities().glPauseTransformFeedback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void glResumeTransformFeedback() {
        long __functionAddress = GL.getCapabilities().glResumeTransformFeedback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void glDrawTransformFeedback(int mode, int id) {
        long __functionAddress = GL.getCapabilities().glDrawTransformFeedback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, id);
    }

    public static void glDrawTransformFeedbackStream(int mode, int id, int stream) {
        long __functionAddress = GL.getCapabilities().glDrawTransformFeedbackStream;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, id, stream);
    }

    public static void glBeginQueryIndexed(int target, int index, int id) {
        long __functionAddress = GL.getCapabilities().glBeginQueryIndexed;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index, id);
    }

    public static void glEndQueryIndexed(int target, int index) {
        long __functionAddress = GL.getCapabilities().glEndQueryIndexed;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index);
    }

    public static void nglGetQueryIndexediv(int target, int index, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetQueryIndexediv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, pname, params);
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryIndexedi(int target, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDrawArraysIndirect(int mode, int[] indirect) {
        long __functionAddress = GL.getCapabilities().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, 16);
            GLChecks.ensureBufferObject(36675, false);
        }
        JNI.callPV(__functionAddress, mode, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, int[] indirect) {
        long __functionAddress = GL.getCapabilities().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, 20);
            GLChecks.ensureBufferObject(36675, false);
        }
        JNI.callPV(__functionAddress, mode, type, indirect);
    }

    public static void glUniform1dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniformMatrix2dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, transpose, value);
    }

    public static void glUniformMatrix3dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 9, transpose, value);
    }

    public static void glUniformMatrix4dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 4, transpose, value);
    }

    public static void glUniformMatrix2x3dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 6, transpose, value);
    }

    public static void glUniformMatrix2x4dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 3, transpose, value);
    }

    public static void glUniformMatrix3x2dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 6, transpose, value);
    }

    public static void glUniformMatrix3x4dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 12, transpose, value);
    }

    public static void glUniformMatrix4x2dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 3, transpose, value);
    }

    public static void glUniformMatrix4x3dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 12, transpose, value);
    }

    public static void glGetUniformdv(int program, int location, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, int[] values) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(values, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int[] length, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, int[] length, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glUniformSubroutinesuiv(int shadertype, int[] indices) {
        long __functionAddress = GL.getCapabilities().glUniformSubroutinesuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, indices.length, indices);
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformSubroutineuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, int[] values) {
        long __functionAddress = GL.getCapabilities().glGetProgramStageiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(values, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, pname, values);
    }

    public static void glPatchParameterfv(int pname, float[] values) {
        long __functionAddress = GL.getCapabilities().glPatchParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (Checks.DEBUG) {
                Checks.checkBuffer(values, GL11.glGetInteger(36466));
            }
        }
        JNI.callPV(__functionAddress, pname, values);
    }

    public static void glDeleteTransformFeedbacks(int[] ids) {
        long __functionAddress = GL.getCapabilities().glDeleteTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGenTransformFeedbacks(int[] ids) {
        long __functionAddress = GL.getCapabilities().glGenTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetQueryIndexediv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, index, pname, params);
    }
}

