/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiviewDrawBuffers {
    public static final int GL_COLOR_ATTACHMENT_EXT = 37104;
    public static final int GL_MULTIVIEW_EXT = 37105;
    public static final int GL_DRAW_BUFFER_EXT = 3073;
    public static final int GL_READ_BUFFER_EXT = 3074;
    public static final int GL_MAX_MULTIVIEW_BUFFERS_EXT = 37106;

    protected EXTMultiviewDrawBuffers() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glReadBufferIndexedEXT, caps.glDrawBuffersIndexedEXT, caps.glGetIntegeri_vEXT);
    }

    public static void glReadBufferIndexedEXT(int src, int index) {
        long __functionAddress = GLES.getCapabilities().glReadBufferIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, src, index);
    }

    public static void nglDrawBuffersIndexedEXT(int n, long location, long indices) {
        long __functionAddress = GLES.getCapabilities().glDrawBuffersIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, n, location, indices);
    }

    public static void glDrawBuffersIndexedEXT(IntBuffer location, IntBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, location.remaining());
        }
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(location.remaining(), MemoryUtil.memAddress(location), MemoryUtil.memAddress(indices));
    }

    public static void nglGetIntegeri_vEXT(int target, int index, long data) {
        long __functionAddress = GLES.getCapabilities().glGetIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetIntegeri_vEXT(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegeriEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress(data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDrawBuffersIndexedEXT(int[] location, int[] indices) {
        long __functionAddress = GLES.getCapabilities().glDrawBuffersIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indices, location.length);
        }
        JNI.callPPV(__functionAddress, location.length, location, indices);
    }

    public static void glGetIntegeri_vEXT(int target, int index, int[] data) {
        long __functionAddress = GLES.getCapabilities().glGetIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }
}

