/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_EXT = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_EXT = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_EXT = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS_EXT = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_EXT = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_EXT = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_EXT = 33377;

    protected EXTRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetGraphicsResetStatusEXT, caps.glReadnPixelsEXT, caps.glGetnUniformfvEXT, caps.glGetnUniformivEXT);
    }

    public static int glGetGraphicsResetStatusEXT() {
        long __functionAddress = GLES.getCapabilities().glGetGraphicsResetStatusEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static void nglReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        long __functionAddress = GLES.getCapabilities().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, true);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, ShortBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, IntBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, FloatBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void nglGetnUniformfvEXT(int program, int location, int bufSize, long params) {
        long __functionAddress = GLES.getCapabilities().glGetnUniformfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfvEXT(int program, int location, FloatBuffer params) {
        EXTRobustness.nglGetnUniformfvEXT(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformfEXT(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTRobustness.nglGetnUniformfvEXT(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnUniformivEXT(int program, int location, int bufSize, long params) {
        long __functionAddress = GLES.getCapabilities().glGetnUniformivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformivEXT(int program, int location, IntBuffer params) {
        EXTRobustness.nglGetnUniformivEXT(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnUniformiEXT(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTRobustness.nglGetnUniformivEXT(program, location, 1, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, short[] data) {
        long __functionAddress = GLES.getCapabilities().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLESChecks.ensureBufferObject(35053, false);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, data.length << 1, data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int[] data) {
        long __functionAddress = GLES.getCapabilities().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLESChecks.ensureBufferObject(35053, false);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, data.length << 2, data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, float[] data) {
        long __functionAddress = GLES.getCapabilities().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLESChecks.ensureBufferObject(35053, false);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, data.length << 2, data);
    }

    public static void glGetnUniformfvEXT(int program, int location, float[] params) {
        long __functionAddress = GLES.getCapabilities().glGetnUniformfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformivEXT(int program, int location, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetnUniformivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }
}

