/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESMapbuffer {
    public static final int GL_WRITE_ONLY_OES = 35001;
    public static final int GL_BUFFER_ACCESS_OES = 35003;
    public static final int GL_BUFFER_MAPPED_OES = 35004;
    public static final int GL_BUFFER_MAP_POINTER_OES = 35005;

    protected OESMapbuffer() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glMapBufferOES, caps.glUnmapBufferOES, caps.glGetBufferPointervOES);
    }

    public static long nglMapBufferOES(int target, int access) {
        long __functionAddress = GLES.getCapabilities().glMapBufferOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress, target, access);
    }

    public static ByteBuffer glMapBufferOES(int target, int access) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        return MemoryUtil.memByteBuffer(__result, GLES20.glGetBufferParameteri(target, 34660));
    }

    public static ByteBuffer glMapBufferOES(int target, int access, ByteBuffer old_buffer) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        int length = GLES20.glGetBufferParameteri(target, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapBufferOES(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static boolean glUnmapBufferOES(int target) {
        long __functionAddress = GLES.getCapabilities().glUnmapBufferOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, target);
    }

    public static void nglGetBufferPointervOES(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetBufferPointervOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferPointervOES(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        OESMapbuffer.nglGetBufferPointervOES(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferPointerOES(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            OESMapbuffer.nglGetBufferPointervOES(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

