/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLogCallback;
import org.lwjgl.ovr.OVRLogCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRInitParams
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int REQUESTEDMINORVERSION;
    public static final int LOGCALLBACK;
    public static final int USERDATA;
    public static final int CONNECTIONTIMEOUTMS;

    OVRInitParams(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRInitParams(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRInitParams.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Flags() {
        return OVRInitParams.nFlags(this.address());
    }

    public int RequestedMinorVersion() {
        return OVRInitParams.nRequestedMinorVersion(this.address());
    }

    public OVRLogCallback LogCallback() {
        return OVRLogCallback.create(OVRInitParams.nLogCallback(this.address()));
    }

    public long UserData() {
        return OVRInitParams.nUserData(this.address());
    }

    public int ConnectionTimeoutMS() {
        return OVRInitParams.nConnectionTimeoutMS(this.address());
    }

    public OVRInitParams Flags(int value) {
        OVRInitParams.nFlags(this.address(), value);
        return this;
    }

    public OVRInitParams RequestedMinorVersion(int value) {
        OVRInitParams.nRequestedMinorVersion(this.address(), value);
        return this;
    }

    public OVRInitParams LogCallback(OVRLogCallbackI value) {
        OVRInitParams.nLogCallback(this.address(), OVRInitParams.addressSafe(value));
        return this;
    }

    public OVRInitParams UserData(long value) {
        OVRInitParams.nUserData(this.address(), value);
        return this;
    }

    public OVRInitParams ConnectionTimeoutMS(int value) {
        OVRInitParams.nConnectionTimeoutMS(this.address(), value);
        return this;
    }

    public OVRInitParams set(int Flags, int RequestedMinorVersion, OVRLogCallbackI LogCallback, long UserData, int ConnectionTimeoutMS) {
        this.Flags(Flags);
        this.RequestedMinorVersion(RequestedMinorVersion);
        this.LogCallback(LogCallback);
        this.UserData(UserData);
        this.ConnectionTimeoutMS(ConnectionTimeoutMS);
        return this;
    }

    public OVRInitParams nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRInitParams set(OVRInitParams src) {
        return this.nset(src.address());
    }

    public static OVRInitParams malloc() {
        return OVRInitParams.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRInitParams calloc() {
        return OVRInitParams.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRInitParams create() {
        return new OVRInitParams(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRInitParams create(long address) {
        return address == 0L ? null : new OVRInitParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRInitParams.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRInitParams.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRInitParams mallocStack() {
        return OVRInitParams.mallocStack(MemoryStack.stackGet());
    }

    public static OVRInitParams callocStack() {
        return OVRInitParams.callocStack(MemoryStack.stackGet());
    }

    public static OVRInitParams mallocStack(MemoryStack stack) {
        return OVRInitParams.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRInitParams callocStack(MemoryStack stack) {
        return OVRInitParams.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRInitParams.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRInitParams.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRInitParams.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRInitParams.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nRequestedMinorVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUESTEDMINORVERSION);
    }

    public static long nLogCallback(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LOGCALLBACK);
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static int nConnectionTimeoutMS(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONNECTIONTIMEOUTMS);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nRequestedMinorVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUESTEDMINORVERSION, value);
    }

    public static void nLogCallback(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LOGCALLBACK, value);
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void nConnectionTimeoutMS(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONNECTIONTIMEOUTMS, value);
    }

    static {
        Struct.Layout layout = OVRInitParams.__struct(OVRInitParams.__member(4), OVRInitParams.__member(4), OVRInitParams.__member(POINTER_SIZE), OVRInitParams.__member(POINTER_SIZE), OVRInitParams.__member(4), OVRInitParams.__padding(4, Pointer.BITS64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REQUESTEDMINORVERSION = layout.offsetof(1);
        LOGCALLBACK = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        CONNECTIONTIMEOUTMS = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVRInitParams, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRInitParams newInstance(long address) {
            return new OVRInitParams(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Flags() {
            return OVRInitParams.nFlags(this.address());
        }

        public int RequestedMinorVersion() {
            return OVRInitParams.nRequestedMinorVersion(this.address());
        }

        public OVRLogCallback LogCallback() {
            return OVRLogCallback.create(OVRInitParams.nLogCallback(this.address()));
        }

        public long UserData() {
            return OVRInitParams.nUserData(this.address());
        }

        public int ConnectionTimeoutMS() {
            return OVRInitParams.nConnectionTimeoutMS(this.address());
        }

        public Buffer Flags(int value) {
            OVRInitParams.nFlags(this.address(), value);
            return this;
        }

        public Buffer RequestedMinorVersion(int value) {
            OVRInitParams.nRequestedMinorVersion(this.address(), value);
            return this;
        }

        public Buffer LogCallback(OVRLogCallbackI value) {
            OVRInitParams.nLogCallback(this.address(), OVRInitParams.addressSafe(value));
            return this;
        }

        public Buffer UserData(long value) {
            OVRInitParams.nUserData(this.address(), value);
            return this;
        }

        public Buffer ConnectionTimeoutMS(int value) {
            OVRInitParams.nConnectionTimeoutMS(this.address(), value);
            return this;
        }
    }
}

