/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerEyeMatrix
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int RENDERPOSE;
    public static final int MATRIX;
    public static final int SENSORSAMPLETIME;

    OVRLayerEyeMatrix(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerEyeMatrix(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRLayerEyeMatrix.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerEyeMatrix.nHeader(this.address());
    }

    public PointerBuffer ColorTexture() {
        return OVRLayerEyeMatrix.nColorTexture(this.address());
    }

    public long ColorTexture(int index) {
        return OVRLayerEyeMatrix.nColorTexture(this.address(), index);
    }

    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeMatrix.nViewport(this.address());
    }

    public OVRRecti Viewport(int index) {
        return OVRLayerEyeMatrix.nViewport(this.address(), index);
    }

    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeMatrix.nRenderPose(this.address());
    }

    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeMatrix.nRenderPose(this.address(), index);
    }

    public OVRMatrix4f.Buffer Matrix() {
        return OVRLayerEyeMatrix.nMatrix(this.address());
    }

    public OVRMatrix4f Matrix(int index) {
        return OVRLayerEyeMatrix.nMatrix(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeMatrix.nSensorSampleTime(this.address());
    }

    public OVRLayerEyeMatrix Header(OVRLayerHeader value) {
        OVRLayerEyeMatrix.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix ColorTexture(PointerBuffer value) {
        OVRLayerEyeMatrix.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix ColorTexture(int index, long value) {
        OVRLayerEyeMatrix.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(OVRRecti.Buffer value) {
        OVRLayerEyeMatrix.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(int index, OVRRecti value) {
        OVRLayerEyeMatrix.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(OVRPosef.Buffer value) {
        OVRLayerEyeMatrix.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(int index, OVRPosef value) {
        OVRLayerEyeMatrix.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Matrix(OVRMatrix4f.Buffer value) {
        OVRLayerEyeMatrix.nMatrix(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Matrix(int index, OVRMatrix4f value) {
        OVRLayerEyeMatrix.nMatrix(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix SensorSampleTime(double value) {
        OVRLayerEyeMatrix.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRPosef.Buffer RenderPose, OVRMatrix4f.Buffer Matrix, double SensorSampleTime) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.RenderPose(RenderPose);
        this.Matrix(Matrix);
        this.SensorSampleTime(SensorSampleTime);
        return this;
    }

    public OVRLayerEyeMatrix nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerEyeMatrix set(OVRLayerEyeMatrix src) {
        return this.nset(src.address());
    }

    public static OVRLayerEyeMatrix malloc() {
        return OVRLayerEyeMatrix.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerEyeMatrix calloc() {
        return OVRLayerEyeMatrix.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerEyeMatrix create() {
        return new OVRLayerEyeMatrix(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRLayerEyeMatrix create(long address) {
        return address == 0L ? null : new OVRLayerEyeMatrix(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerEyeMatrix.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerEyeMatrix.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRLayerEyeMatrix mallocStack() {
        return OVRLayerEyeMatrix.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeMatrix callocStack() {
        return OVRLayerEyeMatrix.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeMatrix mallocStack(MemoryStack stack) {
        return OVRLayerEyeMatrix.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerEyeMatrix callocStack(MemoryStack stack) {
        return OVRLayerEyeMatrix.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeMatrix.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeMatrix.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeMatrix.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeMatrix.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + (long)(index * Integer.MAX_VALUE));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF));
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + (long)(index * OVRPosef.SIZEOF));
    }

    public static OVRMatrix4f.Buffer nMatrix(long struct) {
        return OVRMatrix4f.create(struct + (long)MATRIX, 2);
    }

    public static OVRMatrix4f nMatrix(long struct, int index) {
        return OVRMatrix4f.create(struct + (long)MATRIX + (long)(index * OVRMatrix4f.SIZEOF));
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SENSORSAMPLETIME);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + (long)(index * POINTER_SIZE), value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF), OVRRecti.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE + (long)(index * OVRPosef.SIZEOF), OVRPosef.SIZEOF);
    }

    public static void nMatrix(long struct, OVRMatrix4f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)MATRIX, value.remaining() * OVRMatrix4f.SIZEOF);
    }

    public static void nMatrix(long struct, int index, OVRMatrix4f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MATRIX + (long)(index * OVRMatrix4f.SIZEOF), OVRMatrix4f.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SENSORSAMPLETIME, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerEyeMatrix.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerEyeMatrix.__struct(OVRLayerEyeMatrix.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF), OVRLayerEyeMatrix.__array(POINTER_SIZE, 2), OVRLayerEyeMatrix.__array(OVRRecti.SIZEOF, OVRRecti.ALIGNOF, 2), OVRLayerEyeMatrix.__array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, 2), OVRLayerEyeMatrix.__array(OVRMatrix4f.SIZEOF, OVRMatrix4f.ALIGNOF, 2), OVRLayerEyeMatrix.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        RENDERPOSE = layout.offsetof(3);
        MATRIX = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerEyeMatrix, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRLayerEyeMatrix newInstance(long address) {
            return new OVRLayerEyeMatrix(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerEyeMatrix.nHeader(this.address());
        }

        public PointerBuffer ColorTexture() {
            return OVRLayerEyeMatrix.nColorTexture(this.address());
        }

        public long ColorTexture(int index) {
            return OVRLayerEyeMatrix.nColorTexture(this.address(), index);
        }

        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeMatrix.nViewport(this.address());
        }

        public OVRRecti Viewport(int index) {
            return OVRLayerEyeMatrix.nViewport(this.address(), index);
        }

        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeMatrix.nRenderPose(this.address());
        }

        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeMatrix.nRenderPose(this.address(), index);
        }

        public OVRMatrix4f.Buffer Matrix() {
            return OVRLayerEyeMatrix.nMatrix(this.address());
        }

        public OVRMatrix4f Matrix(int index) {
            return OVRLayerEyeMatrix.nMatrix(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeMatrix.nSensorSampleTime(this.address());
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerEyeMatrix.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(PointerBuffer value) {
            OVRLayerEyeMatrix.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, long value) {
            OVRLayerEyeMatrix.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(OVRRecti.Buffer value) {
            OVRLayerEyeMatrix.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, OVRRecti value) {
            OVRLayerEyeMatrix.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(OVRPosef.Buffer value) {
            OVRLayerEyeMatrix.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, OVRPosef value) {
            OVRLayerEyeMatrix.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer Matrix(OVRMatrix4f.Buffer value) {
            OVRLayerEyeMatrix.nMatrix(this.address(), value);
            return this;
        }

        public Buffer Matrix(int index, OVRMatrix4f value) {
            OVRLayerEyeMatrix.nMatrix(this.address(), index, value);
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeMatrix.nSensorSampleTime(this.address(), value);
            return this;
        }
    }
}

