/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRVector2i;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRRecti
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POS;
    public static final int SIZE;

    OVRRecti(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRRecti(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRRecti.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRVector2i Pos() {
        return OVRRecti.nPos(this.address());
    }

    public OVRSizei Size() {
        return OVRRecti.nSize(this.address());
    }

    public OVRRecti Pos(OVRVector2i value) {
        OVRRecti.nPos(this.address(), value);
        return this;
    }

    public OVRRecti Size(OVRSizei value) {
        OVRRecti.nSize(this.address(), value);
        return this;
    }

    public OVRRecti set(OVRVector2i Pos, OVRSizei Size) {
        this.Pos(Pos);
        this.Size(Size);
        return this;
    }

    public OVRRecti nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRRecti set(OVRRecti src) {
        return this.nset(src.address());
    }

    public static OVRRecti malloc() {
        return OVRRecti.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRRecti calloc() {
        return OVRRecti.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRRecti create() {
        return new OVRRecti(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRRecti create(long address) {
        return address == 0L ? null : new OVRRecti(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRRecti.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRRecti.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRRecti mallocStack() {
        return OVRRecti.mallocStack(MemoryStack.stackGet());
    }

    public static OVRRecti callocStack() {
        return OVRRecti.callocStack(MemoryStack.stackGet());
    }

    public static OVRRecti mallocStack(MemoryStack stack) {
        return OVRRecti.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRRecti callocStack(MemoryStack stack) {
        return OVRRecti.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRRecti.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRRecti.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRRecti.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRRecti.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRVector2i nPos(long struct) {
        return OVRVector2i.create(struct + (long)POS);
    }

    public static OVRSizei nSize(long struct) {
        return OVRSizei.create(struct + (long)SIZE);
    }

    public static void nPos(long struct, OVRVector2i value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POS, OVRVector2i.SIZEOF);
    }

    public static void nSize(long struct, OVRSizei value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SIZE, OVRSizei.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRRecti.__struct(OVRRecti.__member(OVRVector2i.SIZEOF, OVRVector2i.ALIGNOF), OVRRecti.__member(OVRSizei.SIZEOF, OVRSizei.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRRecti, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRRecti newInstance(long address) {
            return new OVRRecti(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRVector2i Pos() {
            return OVRRecti.nPos(this.address());
        }

        public OVRSizei Size() {
            return OVRRecti.nSize(this.address());
        }

        public Buffer Pos(OVRVector2i value) {
            OVRRecti.nPos(this.address(), value);
            return this;
        }

        public Buffer Size(OVRSizei value) {
            OVRRecti.nSize(this.address(), value);
            return this;
        }
    }
}

