/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRSessionStatus
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISVISIBLE;
    public static final int HMDPRESENT;
    public static final int HMDMOUNTED;
    public static final int DISPLAYLOST;
    public static final int SHOULDQUIT;
    public static final int SHOULDRECENTER;

    OVRSessionStatus(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRSessionStatus(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRSessionStatus.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean IsVisible() {
        return OVRSessionStatus.nIsVisible(this.address());
    }

    public boolean HmdPresent() {
        return OVRSessionStatus.nHmdPresent(this.address());
    }

    public boolean HmdMounted() {
        return OVRSessionStatus.nHmdMounted(this.address());
    }

    public boolean DisplayLost() {
        return OVRSessionStatus.nDisplayLost(this.address());
    }

    public boolean ShouldQuit() {
        return OVRSessionStatus.nShouldQuit(this.address());
    }

    public boolean ShouldRecenter() {
        return OVRSessionStatus.nShouldRecenter(this.address());
    }

    public static OVRSessionStatus malloc() {
        return OVRSessionStatus.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRSessionStatus calloc() {
        return OVRSessionStatus.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRSessionStatus create() {
        return new OVRSessionStatus(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRSessionStatus create(long address) {
        return address == 0L ? null : new OVRSessionStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRSessionStatus.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRSessionStatus.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRSessionStatus mallocStack() {
        return OVRSessionStatus.mallocStack(MemoryStack.stackGet());
    }

    public static OVRSessionStatus callocStack() {
        return OVRSessionStatus.callocStack(MemoryStack.stackGet());
    }

    public static OVRSessionStatus mallocStack(MemoryStack stack) {
        return OVRSessionStatus.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRSessionStatus callocStack(MemoryStack stack) {
        return OVRSessionStatus.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRSessionStatus.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRSessionStatus.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsVisible(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISVISIBLE) != 0;
    }

    public static boolean nHmdPresent(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HMDPRESENT) != 0;
    }

    public static boolean nHmdMounted(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HMDMOUNTED) != 0;
    }

    public static boolean nDisplayLost(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DISPLAYLOST) != 0;
    }

    public static boolean nShouldQuit(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SHOULDQUIT) != 0;
    }

    public static boolean nShouldRecenter(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SHOULDRECENTER) != 0;
    }

    static {
        Struct.Layout layout = OVRSessionStatus.__struct(OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISVISIBLE = layout.offsetof(0);
        HMDPRESENT = layout.offsetof(1);
        HMDMOUNTED = layout.offsetof(2);
        DISPLAYLOST = layout.offsetof(3);
        SHOULDQUIT = layout.offsetof(4);
        SHOULDRECENTER = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<OVRSessionStatus, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRSessionStatus newInstance(long address) {
            return new OVRSessionStatus(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean IsVisible() {
            return OVRSessionStatus.nIsVisible(this.address());
        }

        public boolean HmdPresent() {
            return OVRSessionStatus.nHmdPresent(this.address());
        }

        public boolean HmdMounted() {
            return OVRSessionStatus.nHmdMounted(this.address());
        }

        public boolean DisplayLost() {
            return OVRSessionStatus.nDisplayLost(this.address());
        }

        public boolean ShouldQuit() {
            return OVRSessionStatus.nShouldQuit(this.address());
        }

        public boolean ShouldRecenter() {
            return OVRSessionStatus.nShouldRecenter(this.address());
        }
    }
}

