/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.DoubleBuffer;
import org.lwjgl.ovr.OVRDetectResult;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRTimewarpProjectionDesc;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class OVRUtil {
    public static final int ovrProjection_None = 0;
    public static final int ovrProjection_LeftHanded = 1;
    public static final int ovrProjection_FarLessThanNear = 2;
    public static final int ovrProjection_FarClipAtInfinity = 4;
    public static final int ovrProjection_ClipRangeOpenGL = 8;

    protected OVRUtil() {
        throw new UnsupportedOperationException();
    }

    public static native void novr_Detect(int var0, long var1);

    public static void ovr_Detect(int timeoutMilliseconds, OVRDetectResult __result) {
        OVRUtil.novr_Detect(timeoutMilliseconds, __result.address());
    }

    public static native void novrMatrix4f_Projection(long var0, float var2, float var3, int var4, long var5);

    public static void ovrMatrix4f_Projection(OVRFovPort fov, float znear, float zfar, int projectionModFlags, OVRMatrix4f __result) {
        OVRUtil.novrMatrix4f_Projection(fov.address(), znear, zfar, projectionModFlags, __result.address());
    }

    public static native void novrTimewarpProjectionDesc_FromProjection(long var0, int var2, long var3);

    public static void ovrTimewarpProjectionDesc_FromProjection(OVRMatrix4f projection, int projectionModFlags, OVRTimewarpProjectionDesc __result) {
        OVRUtil.novrTimewarpProjectionDesc_FromProjection(projection.address(), projectionModFlags, __result.address());
    }

    public static native void novrMatrix4f_OrthoSubProjection(long var0, long var2, float var4, float var5, long var6);

    public static void ovrMatrix4f_OrthoSubProjection(OVRMatrix4f projection, OVRVector2f orthoScale, float orthoDistance, float HmdToEyeOffsetX, OVRMatrix4f __result) {
        OVRUtil.novrMatrix4f_OrthoSubProjection(projection.address(), orthoScale.address(), orthoDistance, HmdToEyeOffsetX, __result.address());
    }

    public static native void novr_CalcEyePoses(long var0, long var2, long var4);

    public static void ovr_CalcEyePoses(OVRPosef headPose, OVRVector3f.Buffer HmdToEyeOffset, OVRPosef.Buffer outEyePoses) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(HmdToEyeOffset, 2);
            Checks.checkBuffer(outEyePoses, 2);
        }
        OVRUtil.novr_CalcEyePoses(headPose.address(), HmdToEyeOffset.address(), outEyePoses.address());
    }

    public static native void novr_GetEyePoses(long var0, long var2, boolean var4, long var5, long var7, long var9);

    public static void ovr_GetEyePoses(long session, long frameIndex, boolean latencyMarker, OVRVector3f.Buffer HmdToEyeOffset, OVRPosef.Buffer outEyePoses, DoubleBuffer outSensorSampleTime) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkBuffer(HmdToEyeOffset, 2);
            Checks.checkBuffer(outEyePoses, 2);
        }
        OVRUtil.novr_GetEyePoses(session, frameIndex, latencyMarker, HmdToEyeOffset.address(), outEyePoses.address(), MemoryUtil.memAddressSafe(outSensorSampleTime));
    }

    public static native void novrPosef_FlipHandedness(long var0, long var2);

    public static void ovrPosef_FlipHandedness(OVRPosef inPose, OVRPosef outPose) {
        OVRUtil.novrPosef_FlipHandedness(inPose.address(), outPose.address());
    }

    public static native void novr_GetEyePoses(long var0, long var2, boolean var4, long var5, long var7, double[] var9);

    public static void ovr_GetEyePoses(long session, long frameIndex, boolean latencyMarker, OVRVector3f.Buffer HmdToEyeOffset, OVRPosef.Buffer outEyePoses, double[] outSensorSampleTime) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkBuffer(HmdToEyeOffset, 2);
            Checks.checkBuffer(outEyePoses, 2);
        }
        OVRUtil.novr_GetEyePoses(session, frameIndex, latencyMarker, HmdToEyeOffset.address(), outEyePoses.address(), outSensorSampleTime);
    }

    static {
        Library.initialize();
    }
}

