/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibraryLoader;

public final class Library {
    public static final String JNI_LIBRARY_NAME = Configuration.LIBRARY_NAME.get(System.getProperty("os.arch").contains("64") ? "lwjgl" : "lwjgl32");
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final Pattern PATH_SEPARATOR = Pattern.compile(File.pathSeparator);
    private static final Function<File, Boolean> LOADER_SYSTEM = library -> {
        System.load(library.getAbsolutePath());
        return true;
    };
    private static final Function<File, SharedLibrary> LOADER_NATIVE = library -> APIUtil.apiCreateLibrary(library.getPath());

    private Library() {
    }

    public static void initialize() {
    }

    public static void loadSystem(String name) throws UnsatisfiedLinkError {
        if (new File(name).isAbsolute()) {
            System.load(name);
            APIUtil.apiLog("Loaded library: " + name);
            return;
        }
        try {
            Library.loadSystemRelative(name);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                SharedLibraryLoader.load(name);
                Library.loadSystemRelative(name);
            }
            catch (Throwable t) {
                if (Checks.DEBUG) {
                    t.printStackTrace(APIUtil.DEBUG_STREAM);
                }
                throw e;
            }
        }
    }

    private static void loadSystemRelative(String name) {
        String override = Configuration.LIBRARY_PATH.get();
        if (override != null && Library.loadLibrary(LOADER_SYSTEM, override, Platform.get().mapLibraryName(name), false).booleanValue()) {
            APIUtil.apiLog("Loaded library from " + Configuration.LIBRARY_PATH.getProperty() + ": " + name);
            return;
        }
        try {
            System.loadLibrary(name);
            APIUtil.apiLog("Loaded library from java.library.path: " + name);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                System.load(new File("./" + Platform.get().mapLibraryName(name)).getAbsolutePath());
                APIUtil.apiLog("Loaded library from the working directory: " + name);
            }
            catch (UnsatisfiedLinkError ignored) {
                throw e;
            }
        }
    }

    public static SharedLibrary loadNative(String name) {
        if (new File(name).isAbsolute()) {
            return APIUtil.apiCreateLibrary(name);
        }
        try {
            return Library.loadNativeRelative(name);
        }
        catch (RuntimeException e) {
            try {
                SharedLibraryLoader.load(name);
                return Library.loadNativeRelative(name);
            }
            catch (Throwable t) {
                if (Checks.DEBUG) {
                    t.printStackTrace(APIUtil.DEBUG_STREAM);
                }
                throw e;
            }
        }
    }

    private static SharedLibrary loadNativeRelative(String name) {
        SharedLibrary lib;
        String libName = Platform.get().mapLibraryName(name);
        String override = Configuration.LIBRARY_PATH.get();
        if (override != null && (lib = (SharedLibrary)Library.loadLibrary(LOADER_NATIVE, override, libName, null)) != null) {
            return lib;
        }
        lib = Library.loadLibrary(LOADER_NATIVE, System.getProperty(JAVA_LIBRARY_PATH), libName, null);
        if (lib != null) {
            return lib;
        }
        try {
            return APIUtil.apiCreateLibrary(libName);
        }
        catch (RuntimeException e) {
            try {
                return APIUtil.apiCreateLibrary("./" + libName);
            }
            catch (Exception ignored) {
                throw e;
            }
        }
    }

    public static SharedLibrary loadNative(Configuration<String> name, String ... defaultNames) {
        SharedLibrary library;
        block8: {
            if (name.get() != null) {
                return Library.loadNative(name.get());
            }
            if (defaultNames.length <= 1) {
                if (defaultNames.length == 0) {
                    throw new RuntimeException("No default names specified.");
                }
                return Library.loadNative(defaultNames[0]);
            }
            library = null;
            try {
                library = Library.loadNative(defaultNames[0]);
            }
            catch (Exception e) {
                for (int i = 1; i < defaultNames.length; ++i) {
                    try {
                        library = Library.loadNative(defaultNames[i]);
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (library != null) break block8;
                throw new RuntimeException("Failed to load library.", e);
            }
        }
        return library;
    }

    private static <T> T loadLibrary(Function<File, T> loader, String path, String libName, T onFailure) {
        return PATH_SEPARATOR.splitAsStream(path).map(it -> new File(it + File.separator + libName)).filter(File::exists).map(loader).findFirst().orElse(onFailure);
    }

    static {
        if (Checks.DEBUG) {
            APIUtil.apiLog("Version: " + Version.getVersion());
            APIUtil.apiLog("\t OS: " + System.getProperty("os.name") + " v" + System.getProperty("os.version"));
            APIUtil.apiLog("\tJRE: " + System.getProperty("java.version") + " " + System.getProperty("os.arch"));
            APIUtil.apiLog("\tJVM: " + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
        }
        try {
            Library.loadSystemRelative(JNI_LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                SharedLibraryLoader.load();
                Library.loadSystemRelative(JNI_LIBRARY_NAME);
            }
            catch (Throwable t) {
                if (Checks.DEBUG) {
                    t.printStackTrace(APIUtil.DEBUG_STREAM);
                }
                throw ule;
            }
        }
    }
}

