/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class POINTFLOAT
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    POINTFLOAT(long address, ByteBuffer container) {
        super(address, container);
    }

    public POINTFLOAT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), POINTFLOAT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return POINTFLOAT.nx(this.address());
    }

    public float y() {
        return POINTFLOAT.ny(this.address());
    }

    public POINTFLOAT x(float value) {
        POINTFLOAT.nx(this.address(), value);
        return this;
    }

    public POINTFLOAT y(float value) {
        POINTFLOAT.ny(this.address(), value);
        return this;
    }

    public POINTFLOAT set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public POINTFLOAT nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public POINTFLOAT set(POINTFLOAT src) {
        return this.nset(src.address());
    }

    public static POINTFLOAT malloc() {
        return POINTFLOAT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static POINTFLOAT calloc() {
        return POINTFLOAT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static POINTFLOAT create() {
        return new POINTFLOAT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static POINTFLOAT create(long address) {
        return address == 0L ? null : new POINTFLOAT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return POINTFLOAT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return POINTFLOAT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static POINTFLOAT mallocStack() {
        return POINTFLOAT.mallocStack(MemoryStack.stackGet());
    }

    public static POINTFLOAT callocStack() {
        return POINTFLOAT.callocStack(MemoryStack.stackGet());
    }

    public static POINTFLOAT mallocStack(MemoryStack stack) {
        return POINTFLOAT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static POINTFLOAT callocStack(MemoryStack stack) {
        return POINTFLOAT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return POINTFLOAT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return POINTFLOAT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return POINTFLOAT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return POINTFLOAT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = POINTFLOAT.__struct(POINTFLOAT.__member(4), POINTFLOAT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<POINTFLOAT, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected POINTFLOAT newInstance(long address) {
            return new POINTFLOAT(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return POINTFLOAT.nx(this.address());
        }

        public float y() {
            return POINTFLOAT.ny(this.address());
        }

        public Buffer x(float value) {
            POINTFLOAT.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            POINTFLOAT.ny(this.address(), value);
            return this;
        }
    }
}

