/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.WinBase;
import org.lwjgl.system.windows.WindowsUtil;

public class WindowsLibrary
extends SharedLibrary.Default {
    public static final long HINSTANCE;

    public WindowsLibrary(String name) {
        super(WindowsLibrary.loadLibrary(name), name);
        if (this.address() == 0L) {
            WindowsUtil.windowsThrowException("Failed to load library: " + name);
        }
        APIUtil.apiLog("Loaded native library: " + name);
    }

    private static long loadLibrary(String name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long l = WinBase.LoadLibrary(stack.UTF16(name));
            return l;
        }
    }

    @Override
    public long getFunctionAddress(ByteBuffer functionName) {
        return WinBase.GetProcAddress(this.address(), functionName);
    }

    @Override
    public void free() {
        if (!WinBase.FreeLibrary(this.address())) {
            WindowsUtil.windowsThrowException("Failed to unload library: " + this.getName());
        }
    }

    static {
        try (MemoryStack stack = MemoryStack.stackPush();){
            HINSTANCE = WinBase.GetModuleHandle(stack.UTF16(Library.JNI_LIBRARY_NAME));
            if (HINSTANCE == 0L) {
                throw new RuntimeException("Failed to retrieve LWJGL module handle.");
            }
        }
    }
}

