/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ParShapesMesh
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POINTS;
    public static final int NPOINTS;
    public static final int TRIANGLES;
    public static final int NTRIANGLES;
    public static final int NORMALS;
    public static final int TCOORDS;

    ParShapesMesh(long address, ByteBuffer container) {
        super(address, container);
    }

    public ParShapesMesh(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ParShapesMesh.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer points(int capacity) {
        return ParShapesMesh.npoints(this.address(), capacity);
    }

    public int npoints() {
        return ParShapesMesh.nnpoints(this.address());
    }

    public ShortBuffer triangles(int capacity) {
        return ParShapesMesh.ntriangles(this.address(), capacity);
    }

    public int ntriangles() {
        return ParShapesMesh.nntriangles(this.address());
    }

    public FloatBuffer normals(int capacity) {
        return ParShapesMesh.nnormals(this.address(), capacity);
    }

    public FloatBuffer tcoords(int capacity) {
        return ParShapesMesh.ntcoords(this.address(), capacity);
    }

    public static ParShapesMesh malloc() {
        return ParShapesMesh.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static ParShapesMesh calloc() {
        return ParShapesMesh.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static ParShapesMesh create() {
        return new ParShapesMesh(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ParShapesMesh create(long address) {
        return address == 0L ? null : new ParShapesMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return ParShapesMesh.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ParShapesMesh.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static ParShapesMesh mallocStack() {
        return ParShapesMesh.mallocStack(MemoryStack.stackGet());
    }

    public static ParShapesMesh callocStack() {
        return ParShapesMesh.callocStack(MemoryStack.stackGet());
    }

    public static ParShapesMesh mallocStack(MemoryStack stack) {
        return ParShapesMesh.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ParShapesMesh callocStack(MemoryStack stack) {
        return ParShapesMesh.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ParShapesMesh.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ParShapesMesh.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ParShapesMesh.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ParShapesMesh.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer npoints(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)POINTS), capacity);
    }

    public static int nnpoints(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NPOINTS);
    }

    public static ShortBuffer ntriangles(long struct, int capacity) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)TRIANGLES), capacity);
    }

    public static int nntriangles(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NTRIANGLES);
    }

    public static FloatBuffer nnormals(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)NORMALS), capacity);
    }

    public static FloatBuffer ntcoords(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)TCOORDS), capacity);
    }

    static {
        Struct.Layout layout = ParShapesMesh.__struct(ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(4), ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(4), ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POINTS = layout.offsetof(0);
        NPOINTS = layout.offsetof(1);
        TRIANGLES = layout.offsetof(2);
        NTRIANGLES = layout.offsetof(3);
        NORMALS = layout.offsetof(4);
        TCOORDS = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<ParShapesMesh, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ParShapesMesh newInstance(long address) {
            return new ParShapesMesh(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer points(int capacity) {
            return ParShapesMesh.npoints(this.address(), capacity);
        }

        public int npoints() {
            return ParShapesMesh.nnpoints(this.address());
        }

        public ShortBuffer triangles(int capacity) {
            return ParShapesMesh.ntriangles(this.address(), capacity);
        }

        public int ntriangles() {
            return ParShapesMesh.nntriangles(this.address());
        }

        public FloatBuffer normals(int capacity) {
            return ParShapesMesh.nnormals(this.address(), capacity);
        }

        public FloatBuffer tcoords(int capacity) {
            return ParShapesMesh.ntcoords(this.address(), capacity);
        }
    }
}

