/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

public final class VKUtil {
    private VKUtil() {
    }

    public static int VK_MAKE_VERSION(int major, int minor, int patch) {
        return major << 22 | minor << 12 | patch;
    }

    public static int VK_VERSION_MAJOR(int apiVersion) {
        return apiVersion >> 22;
    }

    public static int VK_VERSION_MINOR(int apiVersion) {
        return apiVersion >> 12 & 0x3FF;
    }

    public static int VK_VERSION_PATCH(int apiVersion) {
        return apiVersion & 0xFFF;
    }

    public static String translateVulkanResult(int result) {
        switch (result) {
            case 0: {
                return "Command successfully completed.";
            }
            case 1: {
                return "A fence or query has not yet completed.";
            }
            case 2: {
                return "A wait operation has not completed in the specified time.";
            }
            case 3: {
                return "An event is signaled.";
            }
            case 4: {
                return "An event is unsignaled.";
            }
            case 5: {
                return "A return array was too small for the result.";
            }
            case 1000001003: {
                return "A swapchain no longer matches the surface properties exactly, but can still be used to present to the surface successfully.";
            }
            case -1: {
                return "A host memory allocation has failed.";
            }
            case -2: {
                return "A device memory allocation has failed.";
            }
            case -3: {
                return "Initialization of an object could not be completed for implementation-specific reasons.";
            }
            case -4: {
                return "The logical or physical device has been lost.";
            }
            case -5: {
                return "Mapping of a memory object has failed.";
            }
            case -6: {
                return "A requested layer is not present or could not be loaded.";
            }
            case -7: {
                return "A requested extension is not supported.";
            }
            case -8: {
                return "A requested feature is not supported.";
            }
            case -9: {
                return "The requested version of Vulkan is not supported by the driver or is otherwise incompatible for implementation-specific reasons.";
            }
            case -10: {
                return "Too many objects of the type have already been created.";
            }
            case -11: {
                return "A requested format is not supported on this device.";
            }
            case -1000000000: {
                return "A surface is no longer available.";
            }
            case -1000000001: {
                return "The requested window is already connected to a VkSurfaceKHR, or to some other non-Vulkan API.";
            }
            case -1000001004: {
                return "A surface has changed in such a way that it is no longer compatible with the swapchain, and further presentation requests using the swapchain will fail. Applications must query the new surface properties and recreate their swapchain if they wish to continuepresenting to the surface.";
            }
            case -1000003001: {
                return "The display used by a swapchain does not use the same presentable image layout, or is incompatible in a way that prevents sharing an image.";
            }
            case -1000011001: {
                return "A validation layer found an error.";
            }
        }
        return String.format("%s [%d]", "Unknown", result);
    }
}

