/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkClearColorValue
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLOAT32;
    public static final int INT32;
    public static final int UINT32;

    VkClearColorValue(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkClearColorValue(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkClearColorValue.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer float32() {
        return VkClearColorValue.nfloat32(this.address());
    }

    public float float32(int index) {
        return VkClearColorValue.nfloat32(this.address(), index);
    }

    public IntBuffer int32() {
        return VkClearColorValue.nint32(this.address());
    }

    public int int32(int index) {
        return VkClearColorValue.nint32(this.address(), index);
    }

    public IntBuffer uint32() {
        return VkClearColorValue.nuint32(this.address());
    }

    public int uint32(int index) {
        return VkClearColorValue.nuint32(this.address(), index);
    }

    public VkClearColorValue float32(FloatBuffer value) {
        VkClearColorValue.nfloat32(this.address(), value);
        return this;
    }

    public VkClearColorValue float32(int index, float value) {
        VkClearColorValue.nfloat32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue int32(IntBuffer value) {
        VkClearColorValue.nint32(this.address(), value);
        return this;
    }

    public VkClearColorValue int32(int index, int value) {
        VkClearColorValue.nint32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue uint32(IntBuffer value) {
        VkClearColorValue.nuint32(this.address(), value);
        return this;
    }

    public VkClearColorValue uint32(int index, int value) {
        VkClearColorValue.nuint32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkClearColorValue set(VkClearColorValue src) {
        return this.nset(src.address());
    }

    public static VkClearColorValue malloc() {
        return VkClearColorValue.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkClearColorValue calloc() {
        return VkClearColorValue.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkClearColorValue create() {
        return new VkClearColorValue(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkClearColorValue create(long address) {
        return address == 0L ? null : new VkClearColorValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkClearColorValue.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearColorValue.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkClearColorValue mallocStack() {
        return VkClearColorValue.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearColorValue callocStack() {
        return VkClearColorValue.callocStack(MemoryStack.stackGet());
    }

    public static VkClearColorValue mallocStack(MemoryStack stack) {
        return VkClearColorValue.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearColorValue callocStack(MemoryStack stack) {
        return VkClearColorValue.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearColorValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearColorValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearColorValue.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearColorValue.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nfloat32(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)FLOAT32, 4);
    }

    public static float nfloat32(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)FLOAT32 + (long)(index * 4));
    }

    public static IntBuffer nint32(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)INT32, 4);
    }

    public static int nint32(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)INT32 + (long)(index * 4));
    }

    public static IntBuffer nuint32(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)UINT32, 4);
    }

    public static int nuint32(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)UINT32 + (long)(index * 4));
    }

    public static void nfloat32(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)FLOAT32, value.remaining() * 4);
    }

    public static void nfloat32(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)FLOAT32 + (long)(index * 4), value);
    }

    public static void nint32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)INT32, value.remaining() * 4);
    }

    public static void nint32(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)INT32 + (long)(index * 4), value);
    }

    public static void nuint32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)UINT32, value.remaining() * 4);
    }

    public static void nuint32(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)UINT32 + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = VkClearColorValue.__union(VkClearColorValue.__array(4, 4), VkClearColorValue.__array(4, 4), VkClearColorValue.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLOAT32 = layout.offsetof(0);
        INT32 = layout.offsetof(1);
        UINT32 = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkClearColorValue, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkClearColorValue newInstance(long address) {
            return new VkClearColorValue(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer float32() {
            return VkClearColorValue.nfloat32(this.address());
        }

        public float float32(int index) {
            return VkClearColorValue.nfloat32(this.address(), index);
        }

        public IntBuffer int32() {
            return VkClearColorValue.nint32(this.address());
        }

        public int int32(int index) {
            return VkClearColorValue.nint32(this.address(), index);
        }

        public IntBuffer uint32() {
            return VkClearColorValue.nuint32(this.address());
        }

        public int uint32(int index) {
            return VkClearColorValue.nuint32(this.address(), index);
        }

        public Buffer float32(FloatBuffer value) {
            VkClearColorValue.nfloat32(this.address(), value);
            return this;
        }

        public Buffer float32(int index, float value) {
            VkClearColorValue.nfloat32(this.address(), index, value);
            return this;
        }

        public Buffer int32(IntBuffer value) {
            VkClearColorValue.nint32(this.address(), value);
            return this;
        }

        public Buffer int32(int index, int value) {
            VkClearColorValue.nint32(this.address(), index, value);
            return this;
        }

        public Buffer uint32(IntBuffer value) {
            VkClearColorValue.nuint32(this.address(), value);
            return this;
        }

        public Buffer uint32(int index, int value) {
            VkClearColorValue.nuint32(this.address(), index, value);
            return this;
        }
    }
}

