/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceQueueCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures;

public class VkDeviceCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUECREATEINFOCOUNT;
    public static final int PQUEUECREATEINFOS;
    public static final int ENABLEDLAYERCOUNT;
    public static final int PPENABLEDLAYERNAMES;
    public static final int ENABLEDEXTENSIONCOUNT;
    public static final int PPENABLEDEXTENSIONNAMES;
    public static final int PENABLEDFEATURES;

    VkDeviceCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkDeviceCreateInfo.nflags(this.address());
    }

    public int queueCreateInfoCount() {
        return VkDeviceCreateInfo.nqueueCreateInfoCount(this.address());
    }

    public VkDeviceQueueCreateInfo.Buffer pQueueCreateInfos() {
        return VkDeviceCreateInfo.npQueueCreateInfos(this.address());
    }

    public int enabledLayerCount() {
        return VkDeviceCreateInfo.nenabledLayerCount(this.address());
    }

    public PointerBuffer ppEnabledLayerNames() {
        return VkDeviceCreateInfo.nppEnabledLayerNames(this.address());
    }

    public int enabledExtensionCount() {
        return VkDeviceCreateInfo.nenabledExtensionCount(this.address());
    }

    public PointerBuffer ppEnabledExtensionNames() {
        return VkDeviceCreateInfo.nppEnabledExtensionNames(this.address());
    }

    public VkPhysicalDeviceFeatures pEnabledFeatures() {
        return VkDeviceCreateInfo.npEnabledFeatures(this.address());
    }

    public VkDeviceCreateInfo sType(int value) {
        VkDeviceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo pNext(long value) {
        VkDeviceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo flags(int value) {
        VkDeviceCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo pQueueCreateInfos(VkDeviceQueueCreateInfo.Buffer value) {
        VkDeviceCreateInfo.npQueueCreateInfos(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo ppEnabledLayerNames(PointerBuffer value) {
        VkDeviceCreateInfo.nppEnabledLayerNames(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo ppEnabledExtensionNames(PointerBuffer value) {
        VkDeviceCreateInfo.nppEnabledExtensionNames(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo pEnabledFeatures(VkPhysicalDeviceFeatures value) {
        VkDeviceCreateInfo.npEnabledFeatures(this.address(), value);
        return this;
    }

    public VkDeviceCreateInfo set(int sType, long pNext, int flags, VkDeviceQueueCreateInfo.Buffer pQueueCreateInfos, PointerBuffer ppEnabledLayerNames, PointerBuffer ppEnabledExtensionNames, VkPhysicalDeviceFeatures pEnabledFeatures) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pQueueCreateInfos(pQueueCreateInfos);
        this.ppEnabledLayerNames(ppEnabledLayerNames);
        this.ppEnabledExtensionNames(ppEnabledExtensionNames);
        this.pEnabledFeatures(pEnabledFeatures);
        return this;
    }

    public VkDeviceCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkDeviceCreateInfo set(VkDeviceCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkDeviceCreateInfo malloc() {
        return VkDeviceCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceCreateInfo calloc() {
        return VkDeviceCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceCreateInfo create() {
        return new VkDeviceCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceCreateInfo create(long address) {
        return address == 0L ? null : new VkDeviceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceCreateInfo mallocStack() {
        return VkDeviceCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceCreateInfo callocStack() {
        return VkDeviceCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceCreateInfo mallocStack(MemoryStack stack) {
        return VkDeviceCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceCreateInfo callocStack(MemoryStack stack) {
        return VkDeviceCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nqueueCreateInfoCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUECREATEINFOCOUNT);
    }

    public static VkDeviceQueueCreateInfo.Buffer npQueueCreateInfos(long struct) {
        return VkDeviceQueueCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PQUEUECREATEINFOS), VkDeviceCreateInfo.nqueueCreateInfoCount(struct));
    }

    public static int nenabledLayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLEDLAYERCOUNT);
    }

    public static PointerBuffer nppEnabledLayerNames(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)PPENABLEDLAYERNAMES), VkDeviceCreateInfo.nenabledLayerCount(struct));
    }

    public static int nenabledExtensionCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLEDEXTENSIONCOUNT);
    }

    public static PointerBuffer nppEnabledExtensionNames(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)PPENABLEDEXTENSIONNAMES), VkDeviceCreateInfo.nenabledExtensionCount(struct));
    }

    public static VkPhysicalDeviceFeatures npEnabledFeatures(long struct) {
        return VkPhysicalDeviceFeatures.create(MemoryUtil.memGetAddress(struct + (long)PENABLEDFEATURES));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nqueueCreateInfoCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUECREATEINFOCOUNT, value);
    }

    public static void npQueueCreateInfos(long struct, VkDeviceQueueCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUECREATEINFOS, value.address());
        VkDeviceCreateInfo.nqueueCreateInfoCount(struct, value.remaining());
    }

    public static void nenabledLayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLEDLAYERCOUNT, value);
    }

    public static void nppEnabledLayerNames(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPENABLEDLAYERNAMES, MemoryUtil.memAddressSafe(value));
        VkDeviceCreateInfo.nenabledLayerCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nenabledExtensionCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLEDEXTENSIONCOUNT, value);
    }

    public static void nppEnabledExtensionNames(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPENABLEDEXTENSIONNAMES, MemoryUtil.memAddressSafe(value));
        VkDeviceCreateInfo.nenabledExtensionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npEnabledFeatures(long struct, VkPhysicalDeviceFeatures value) {
        MemoryUtil.memPutAddress(struct + (long)PENABLEDFEATURES, VkDeviceCreateInfo.addressSafe(value));
    }

    public static void validate(long struct) {
        int queueCreateInfoCount = VkDeviceCreateInfo.nqueueCreateInfoCount(struct);
        long pQueueCreateInfos = MemoryUtil.memGetAddress(struct + (long)PQUEUECREATEINFOS);
        Checks.checkPointer(pQueueCreateInfos);
        VkDeviceQueueCreateInfo.validate(pQueueCreateInfos, queueCreateInfoCount);
        if (VkDeviceCreateInfo.nenabledLayerCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PPENABLEDLAYERNAMES));
        }
        if (VkDeviceCreateInfo.nenabledExtensionCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PPENABLEDEXTENSIONNAMES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceCreateInfo.__struct(VkDeviceCreateInfo.__member(4), VkDeviceCreateInfo.__member(POINTER_SIZE), VkDeviceCreateInfo.__member(4), VkDeviceCreateInfo.__member(4), VkDeviceCreateInfo.__member(POINTER_SIZE), VkDeviceCreateInfo.__member(4), VkDeviceCreateInfo.__member(POINTER_SIZE), VkDeviceCreateInfo.__member(4), VkDeviceCreateInfo.__member(POINTER_SIZE), VkDeviceCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUECREATEINFOCOUNT = layout.offsetof(3);
        PQUEUECREATEINFOS = layout.offsetof(4);
        ENABLEDLAYERCOUNT = layout.offsetof(5);
        PPENABLEDLAYERNAMES = layout.offsetof(6);
        ENABLEDEXTENSIONCOUNT = layout.offsetof(7);
        PPENABLEDEXTENSIONNAMES = layout.offsetof(8);
        PENABLEDFEATURES = layout.offsetof(9);
    }

    public static final class Buffer
    extends StructBuffer<VkDeviceCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceCreateInfo newInstance(long address) {
            return new VkDeviceCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkDeviceCreateInfo.nflags(this.address());
        }

        public int queueCreateInfoCount() {
            return VkDeviceCreateInfo.nqueueCreateInfoCount(this.address());
        }

        public VkDeviceQueueCreateInfo.Buffer pQueueCreateInfos() {
            return VkDeviceCreateInfo.npQueueCreateInfos(this.address());
        }

        public int enabledLayerCount() {
            return VkDeviceCreateInfo.nenabledLayerCount(this.address());
        }

        public PointerBuffer ppEnabledLayerNames() {
            return VkDeviceCreateInfo.nppEnabledLayerNames(this.address());
        }

        public int enabledExtensionCount() {
            return VkDeviceCreateInfo.nenabledExtensionCount(this.address());
        }

        public PointerBuffer ppEnabledExtensionNames() {
            return VkDeviceCreateInfo.nppEnabledExtensionNames(this.address());
        }

        public VkPhysicalDeviceFeatures pEnabledFeatures() {
            return VkDeviceCreateInfo.npEnabledFeatures(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkDeviceCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pQueueCreateInfos(VkDeviceQueueCreateInfo.Buffer value) {
            VkDeviceCreateInfo.npQueueCreateInfos(this.address(), value);
            return this;
        }

        public Buffer ppEnabledLayerNames(PointerBuffer value) {
            VkDeviceCreateInfo.nppEnabledLayerNames(this.address(), value);
            return this;
        }

        public Buffer ppEnabledExtensionNames(PointerBuffer value) {
            VkDeviceCreateInfo.nppEnabledExtensionNames(this.address(), value);
            return this;
        }

        public Buffer pEnabledFeatures(VkPhysicalDeviceFeatures value) {
            VkDeviceCreateInfo.npEnabledFeatures(this.address(), value);
            return this;
        }
    }
}

